/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.vespa.config.server.filedistribution.AddFileInterface;
import com.yahoo.vespa.config.server.filedistribution.ApplicationFileManager;
import com.yahoo.vespa.config.server.filedistribution.FileDBRegistry;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import java.io.File;
import java.io.Reader;

public class FileDistributionProvider {
    private final FileRegistry fileRegistry;
    private final FileDistribution fileDistribution;
    private final AddFileInterface fileManager;

    public FileDistributionProvider(File applicationDir, FileDistribution fileDistribution) {
        this(new ApplicationFileManager(applicationDir, new FileDirectory(fileDistribution.getFileReferencesDir())), fileDistribution);
        FileDistributionProvider.ensureDirExists(fileDistribution.getFileReferencesDir());
    }

    FileDistributionProvider(FileRegistry fileRegistry, FileDistribution fileDistribution) {
        this(null, fileRegistry, fileDistribution);
    }

    private FileDistributionProvider(AddFileInterface fileManager, FileDistribution fileDistribution) {
        this(fileManager, new FileDBRegistry(fileManager), fileDistribution);
    }

    private FileDistributionProvider(AddFileInterface fileManager, FileRegistry fileRegistry, FileDistribution fileDistribution) {
        this.fileManager = fileManager;
        this.fileRegistry = fileRegistry;
        this.fileDistribution = fileDistribution;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public FileDistribution getFileDistribution() {
        return this.fileDistribution;
    }

    public FileRegistry createPregeneratedFileRegistry(Reader persistedState) {
        return FileDBRegistry.create(this.fileManager, persistedState);
    }

    private static void ensureDirExists(File dir) {
        boolean success;
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new RuntimeException("Could not create directory " + dir.getPath());
        }
    }
}

