/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.container.jdisc.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;

class ProxyResponse
extends HttpResponse {
    private final CloseableHttpResponse clientResponse;

    ProxyResponse(CloseableHttpResponse clientResponse) {
        super(clientResponse.getStatusLine().getStatusCode());
        this.clientResponse = clientResponse;
    }

    public String getContentType() {
        return Optional.ofNullable(this.clientResponse.getFirstHeader("Content-Type")).map(NameValuePair::getValue).orElseGet(() -> super.getContentType());
    }

    public void render(OutputStream outputStream) throws IOException {
        try (CloseableHttpResponse closeableHttpResponse = this.clientResponse;){
            this.clientResponse.getEntity().writeTo(outputStream);
        }
    }
}

