/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.CompressedApplicationInputStream;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.PrepareResult;
import com.yahoo.vespa.config.server.http.v2.SessionCreateHandler;
import com.yahoo.vespa.config.server.http.v2.SessionPrepareAndActivateResponse;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.servlet.http.Part;
import org.apache.hc.core5.http.ContentType;
import org.eclipse.jetty.http.MultiPartFormInputStream;

public class ApplicationApiHandler
extends SessionHandler {
    public static final String APPLICATION_X_GZIP = "application/x-gzip";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_PARAMS = "prepareParams";
    public static final String MULTIPART_APPLICATION_PACKAGE = "applicationPackage";
    public static final String contentTypeHeader = "Content-Type";
    private final TenantRepository tenantRepository;
    private final Duration zookeeperBarrierTimeout;
    private final Zone zone;

    @Inject
    public ApplicationApiHandler(LoggingRequestHandler.Context ctx, ApplicationRepository applicationRepository, ConfigserverConfig configserverConfig, Zone zone) {
        super(ctx, applicationRepository);
        this.tenantRepository = applicationRepository.tenantRepository();
        this.zookeeperBarrierTimeout = Duration.ofSeconds(configserverConfig.zookeeper().barrierTimeout());
        this.zone = zone;
    }

    @Override
    protected HttpResponse handlePOST(HttpRequest request) {
        CompressedApplicationInputStream compressedStream;
        PrepareParams prepareParams;
        SessionCreateHandler.validateDataAndHeader(request, List.of(APPLICATION_X_GZIP, APPLICATION_ZIP, MULTIPART_FORM_DATA));
        TenantName tenantName = this.validateTenant(request);
        boolean multipartRequest = Optional.ofNullable(request.getHeader(contentTypeHeader)).map(ContentType::parse).map(contentType -> contentType.getMimeType().equalsIgnoreCase(MULTIPART_FORM_DATA)).orElse(false);
        if (multipartRequest) {
            try {
                MultiPartFormInputStream multiPartFormInputStream = new MultiPartFormInputStream(request.getData(), request.getHeader(contentTypeHeader), null, null);
                Map<String, Part> parts = multiPartFormInputStream.getParts().stream().collect(Collectors.toMap(Part::getName, p -> p));
                byte[] params = parts.get(MULTIPART_PARAMS).getInputStream().readAllBytes();
                this.log.log(Level.FINE, "Deploy parameters: [{0}]", new String(params, StandardCharsets.UTF_8));
                prepareParams = PrepareParams.fromJson(params, tenantName, this.zookeeperBarrierTimeout);
                Part appPackagePart = parts.get(MULTIPART_APPLICATION_PACKAGE);
                compressedStream = CompressedApplicationInputStream.createFromCompressedStream(appPackagePart.getInputStream(), appPackagePart.getContentType());
            }
            catch (IOException e) {
                this.log.log(Level.WARNING, "Unable to parse multipart in deploy", e);
                throw new BadRequestException("Request contains invalid data");
            }
        } else {
            prepareParams = PrepareParams.fromHttpRequest(request, tenantName, this.zookeeperBarrierTimeout);
            compressedStream = CompressedApplicationInputStream.createFromCompressedStream(request.getData(), request.getHeader(contentTypeHeader));
        }
        PrepareResult result = this.applicationRepository.deploy(compressedStream, prepareParams);
        return new SessionPrepareAndActivateResponse(result, request, prepareParams.getApplicationId(), this.zone);
    }

    public Duration getTimeout() {
        return this.zookeeperBarrierTimeout.plus(Duration.ofSeconds(10L));
    }

    private TenantName validateTenant(HttpRequest request) {
        TenantName tenantName = ApplicationApiHandler.getTenantNameFromRequest(request);
        Utils.checkThatTenantExists(this.tenantRepository, tenantName);
        return tenantName;
    }

    public static TenantName getTenantNameFromRequest(HttpRequest request) {
        BindingMatch<?> bm = Utils.getBindingMatch(request, "http://*/application/v2/tenant/*/prepareandactivate*");
        return TenantName.from((String)bm.group(2));
    }
}

