/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import ai.vespa.util.http.hc4.VespaHttpClientBuilder;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.DeploymentMetricsAggregator;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class ClusterDeploymentMetricsRetriever {
    private static final Logger log = Logger.getLogger(ClusterDeploymentMetricsRetriever.class.getName());
    private static final String VESPA_CONTAINER = "vespa.container";
    private static final String VESPA_QRSERVER = "vespa.qrserver";
    private static final String VESPA_DISTRIBUTOR = "vespa.distributor";
    private static final String VESPA_CONTAINER_CLUSTERCONTROLLER = "vespa.container-clustercontroller";
    private static final List<String> WANTED_METRIC_SERVICES = List.of("vespa.container", "vespa.qrserver", "vespa.distributor", "vespa.container-clustercontroller");
    private static final ExecutorService executor = Executors.newFixedThreadPool(10, (ThreadFactory)new DaemonThreadFactory("cluster-deployment-metrics-retriever-"));
    private static final CloseableHttpClient httpClient = VespaHttpClientBuilder.create(registry -> new PoolingHttpClientConnectionManager(registry, null, null, null, 1L, TimeUnit.MINUTES)).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout((int)Duration.ofSeconds(60L).toMillis()).setConnectTimeout((int)Duration.ofSeconds(10L).toMillis()).setSocketTimeout((int)Duration.ofSeconds(10L).toMillis()).build()).build();

    public Map<ClusterInfo, DeploymentMetricsAggregator> requestMetricsGroupedByCluster(Collection<URI> hosts) {
        ConcurrentHashMap<ClusterInfo, DeploymentMetricsAggregator> clusterMetricsMap = new ConcurrentHashMap<ClusterInfo, DeploymentMetricsAggregator>();
        long startTime = System.currentTimeMillis();
        List jobs = hosts.stream().map(hostUri -> () -> {
            try {
                ClusterDeploymentMetricsRetriever.getHostMetrics(hostUri, clusterMetricsMap);
            }
            catch (Exception e) {
                log.log(Level.FINE, e, () -> "Failed to download metrics: " + e.getMessage());
            }
            return null;
        }).collect(Collectors.toList());
        try {
            executor.invokeAll(jobs, 1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to retrieve metrics in time: " + e.getMessage(), e);
        }
        log.log(Level.FINE, () -> String.format("Metric retrieval for %d nodes took %d milliseconds", hosts.size(), System.currentTimeMillis() - startTime));
        return clusterMetricsMap;
    }

    private static void getHostMetrics(URI hostURI, Map<ClusterInfo, DeploymentMetricsAggregator> clusterMetricsMap) {
        Slime responseBody = ClusterDeploymentMetricsRetriever.doMetricsRequest(hostURI);
        Cursor error = responseBody.get().field("error_message");
        if (error.valid()) {
            log.info("Failed to retrieve metrics from " + hostURI + ": " + error.asString());
        }
        Cursor services = responseBody.get().field("services");
        services.traverse((i, servicesInspector) -> ClusterDeploymentMetricsRetriever.parseService(servicesInspector, clusterMetricsMap));
    }

    private static void parseService(Inspector service, Map<ClusterInfo, DeploymentMetricsAggregator> clusterMetricsMap) {
        String serviceName = service.field("name").asString();
        if (!WANTED_METRIC_SERVICES.contains(serviceName)) {
            return;
        }
        service.field("metrics").traverse((i, metric) -> ClusterDeploymentMetricsRetriever.addMetricsToAggregator(serviceName, metric, clusterMetricsMap));
    }

    private static void addMetricsToAggregator(String serviceName, Inspector metric, Map<ClusterInfo, DeploymentMetricsAggregator> clusterMetricsMap) {
        Inspector values = metric.field("values");
        ClusterInfo clusterInfo = ClusterDeploymentMetricsRetriever.getClusterInfoFromDimensions(metric.field("dimensions"));
        Supplier<DeploymentMetricsAggregator> aggregator = () -> clusterMetricsMap.computeIfAbsent(clusterInfo, c -> new DeploymentMetricsAggregator());
        switch (serviceName) {
            case "vespa.container": {
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("query_latency.sum")).ifPresent(qlSum -> ((DeploymentMetricsAggregator)aggregator.get()).addContainerLatency(qlSum, values.field("query_latency.count").asDouble()));
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("feed.latency.sum")).ifPresent(flSum -> ((DeploymentMetricsAggregator)aggregator.get()).addFeedLatency(flSum, values.field("feed.latency.count").asDouble()));
                break;
            }
            case "vespa.qrserver": {
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("query_latency.sum")).ifPresent(qlSum -> ((DeploymentMetricsAggregator)aggregator.get()).addQrLatency(qlSum, values.field("query_latency.count").asDouble()));
                break;
            }
            case "vespa.distributor": {
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("vds.distributor.docsstored.average")).ifPresent(docCount -> ((DeploymentMetricsAggregator)aggregator.get()).addDocumentCount(docCount));
                break;
            }
            case "vespa.container-clustercontroller": {
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("cluster-controller.resource_usage.max_memory_utilization.last")).ifPresent(memoryUtil -> ((DeploymentMetricsAggregator)aggregator.get()).addMemoryUsage(memoryUtil, values.field("cluster-controller.resource_usage.memory_limit.last").asDouble()).addDiskUsage(values.field("cluster-controller.resource_usage.max_disk_utilization.last").asDouble(), values.field("cluster-controller.resource_usage.disk_limit.last").asDouble()));
                ClusterDeploymentMetricsRetriever.optionalDouble(values.field("reindexing.progress.last")).ifPresent(progress -> {
                    if (progress < 0.0 || progress >= 1.0) {
                        return;
                    }
                    ((DeploymentMetricsAggregator)aggregator.get()).addReindexingProgress(metric.field("dimensions").field("documenttype").asString(), progress);
                });
            }
        }
    }

    private static ClusterInfo getClusterInfoFromDimensions(Inspector dimensions) {
        return new ClusterInfo(dimensions.field("clusterid").asString(), dimensions.field("clustertype").asString());
    }

    private static Slime doMetricsRequest(URI hostURI) {
        Slime slime;
        block8: {
            HttpGet get = new HttpGet(hostURI);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            try {
                byte[] body = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                slime = SlimeUtils.jsonToSlime((byte[])body);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.info("Was unable to fetch metrics from " + hostURI + " : " + Exceptions.toMessageString((Throwable)e));
                    return new Slime();
                }
            }
            response.close();
        }
        return slime;
    }

    private static OptionalDouble optionalDouble(Inspector field) {
        return field.valid() ? OptionalDouble.of(field.asDouble()) : OptionalDouble.empty();
    }
}

