/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.provision.ActivationContext;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationTransaction;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.Deployer;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.InfraDeployer;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.SecretStoreProvider;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.docproc.jdisc.metric.NullMetric;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.Metric;
import com.yahoo.path.Path;
import com.yahoo.slime.Slime;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.ActivationConflictException;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationCuratorDatabase;
import com.yahoo.vespa.config.server.application.ApplicationReindexing;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.ClusterReindexing;
import com.yahoo.vespa.config.server.application.ClusterReindexingStatusClient;
import com.yahoo.vespa.config.server.application.CompressedApplicationInputStream;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.application.DefaultClusterReindexingStatusClient;
import com.yahoo.vespa.config.server.application.FileDistributionStatus;
import com.yahoo.vespa.config.server.application.HttpProxy;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.RefeedActions;
import com.yahoo.vespa.config.server.configchange.ReindexActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import com.yahoo.vespa.config.server.deploy.DeployHandlerLogger;
import com.yahoo.vespa.config.server.deploy.Deployment;
import com.yahoo.vespa.config.server.deploy.InfraDeployerProvider;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.LogRetriever;
import com.yahoo.vespa.config.server.http.SecretStoreValidator;
import com.yahoo.vespa.config.server.http.SimpleHttpFetcher;
import com.yahoo.vespa.config.server.http.TesterClient;
import com.yahoo.vespa.config.server.http.v2.DeploymentMetricsResponse;
import com.yahoo.vespa.config.server.http.v2.PrepareResult;
import com.yahoo.vespa.config.server.http.v2.ProtonMetricsResponse;
import com.yahoo.vespa.config.server.metrics.DeploymentMetricsRetriever;
import com.yahoo.vespa.config.server.metrics.ProtonMetricsRetriever;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.ApplicationRolesStore;
import com.yahoo.vespa.config.server.tenant.ContainerEndpointsCache;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateMetadataStore;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantMetaData;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.curator.stats.LockStats;
import com.yahoo.vespa.curator.stats.ThreadLockStats;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.InMemoryFlagSource;
import com.yahoo.vespa.orchestrator.Orchestrator;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ApplicationRepository
implements Deployer {
    private static final Logger log = Logger.getLogger(ApplicationRepository.class.getName());
    private final AtomicBoolean bootstrapping = new AtomicBoolean(true);
    private final TenantRepository tenantRepository;
    private final Optional<Provisioner> hostProvisioner;
    private final Optional<InfraDeployer> infraDeployer;
    private final ConfigConvergenceChecker convergeChecker;
    private final HttpProxy httpProxy;
    private final Clock clock;
    private final ConfigserverConfig configserverConfig;
    private final FileDistributionStatus fileDistributionStatus = new FileDistributionStatus();
    private final Orchestrator orchestrator;
    private final LogRetriever logRetriever;
    private final TesterClient testerClient;
    private final Metric metric;
    private final SecretStoreValidator secretStoreValidator;
    private final ClusterReindexingStatusClient clusterReindexingStatusClient;

    @Inject
    public ApplicationRepository(TenantRepository tenantRepository, HostProvisionerProvider hostProvisionerProvider, InfraDeployerProvider infraDeployerProvider, ConfigConvergenceChecker configConvergenceChecker, HttpProxy httpProxy, ConfigserverConfig configserverConfig, Orchestrator orchestrator, TesterClient testerClient, Metric metric, SecretStore secretStore) {
        this(tenantRepository, hostProvisionerProvider.getHostProvisioner(), infraDeployerProvider.getInfraDeployer(), configConvergenceChecker, httpProxy, configserverConfig, orchestrator, new LogRetriever(), Clock.systemUTC(), testerClient, metric, new SecretStoreValidator(secretStore), new DefaultClusterReindexingStatusClient());
    }

    private ApplicationRepository(TenantRepository tenantRepository, Optional<Provisioner> hostProvisioner, Optional<InfraDeployer> infraDeployer, ConfigConvergenceChecker configConvergenceChecker, HttpProxy httpProxy, ConfigserverConfig configserverConfig, Orchestrator orchestrator, LogRetriever logRetriever, Clock clock, TesterClient testerClient, Metric metric, SecretStoreValidator secretStoreValidator, ClusterReindexingStatusClient clusterReindexingStatusClient) {
        this.tenantRepository = Objects.requireNonNull(tenantRepository);
        this.hostProvisioner = Objects.requireNonNull(hostProvisioner);
        this.infraDeployer = Objects.requireNonNull(infraDeployer);
        this.convergeChecker = Objects.requireNonNull(configConvergenceChecker);
        this.httpProxy = Objects.requireNonNull(httpProxy);
        this.configserverConfig = Objects.requireNonNull(configserverConfig);
        this.orchestrator = Objects.requireNonNull(orchestrator);
        this.logRetriever = Objects.requireNonNull(logRetriever);
        this.clock = Objects.requireNonNull(clock);
        this.testerClient = Objects.requireNonNull(testerClient);
        this.metric = Objects.requireNonNull(metric);
        this.secretStoreValidator = Objects.requireNonNull(secretStoreValidator);
        this.clusterReindexingStatusClient = clusterReindexingStatusClient;
    }

    public Metric metric() {
        return this.metric;
    }

    public boolean bootstrapping() {
        return this.bootstrapping.get();
    }

    public void bootstrappingDone() {
        this.bootstrapping.set(false);
    }

    public PrepareResult prepare(long sessionId, PrepareParams prepareParams) {
        DeployHandlerLogger logger = DeployHandlerLogger.forPrepareParams(prepareParams);
        Deployment deployment = this.prepare(sessionId, prepareParams, logger);
        return new PrepareResult(sessionId, deployment.configChangeActions(), logger);
    }

    private Deployment prepare(long sessionId, PrepareParams prepareParams, DeployHandlerLogger logger) {
        Tenant tenant = this.getTenant(prepareParams.getApplicationId());
        Session session = this.validateThatLocalSessionIsNotActive(tenant, sessionId);
        Deployment deployment = Deployment.unprepared(session, this, this.hostProvisioner, tenant, prepareParams, logger, this.clock);
        deployment.prepare();
        ApplicationRepository.logConfigChangeActions(deployment.configChangeActions(), logger);
        log.log(Level.INFO, TenantRepository.logPre(prepareParams.getApplicationId()) + "Session " + sessionId + " prepared successfully. ");
        return deployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrepareResult deploy(CompressedApplicationInputStream in, PrepareParams prepareParams) {
        PrepareResult prepareResult;
        DeployHandlerLogger logger = DeployHandlerLogger.forPrepareParams(prepareParams);
        File tempDir = ((java.nio.file.Path)Exceptions.uncheck(() -> Files.createTempDirectory("deploy", new FileAttribute[0]))).toFile();
        ThreadLockStats threadLockStats = LockStats.getForCurrentThread();
        try {
            threadLockStats.startRecording("deploy of " + prepareParams.getApplicationId().serializedForm());
            prepareResult = this.deploy(this.decompressApplication(in, tempDir), prepareParams, logger);
        }
        finally {
            threadLockStats.stopRecording();
            this.cleanupTempDirectory(tempDir, logger);
        }
        return prepareResult;
    }

    public PrepareResult deploy(File applicationPackage, PrepareParams prepareParams) {
        return this.deploy(applicationPackage, prepareParams, DeployHandlerLogger.forPrepareParams(prepareParams));
    }

    private PrepareResult deploy(File applicationPackage, PrepareParams prepareParams, DeployHandlerLogger logger) {
        ApplicationId applicationId = prepareParams.getApplicationId();
        long sessionId = this.createSession(applicationId, prepareParams.getTimeoutBudget(), applicationPackage);
        Deployment deployment = this.prepare(sessionId, prepareParams, logger);
        deployment.activate();
        return new PrepareResult(sessionId, deployment.configChangeActions(), logger);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application) {
        return this.deployFromLocalActive(application, false);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application, boolean bootstrap) {
        return this.deployFromLocalActive(application, Duration.ofSeconds(this.configserverConfig.zookeeper().barrierTimeout()).plus(Duration.ofSeconds(5L)), bootstrap);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application, Duration timeout, boolean bootstrap) {
        Optional<com.yahoo.config.provision.Deployment> infraDeployment = this.infraDeployer.flatMap(d -> d.getDeployment(application));
        if (infraDeployment.isPresent()) {
            return infraDeployment;
        }
        Tenant tenant = this.tenantRepository.getTenant(application.tenant());
        if (tenant == null) {
            return Optional.empty();
        }
        Session activeSession = this.getActiveLocalSession(tenant, application);
        if (activeSession == null) {
            return Optional.empty();
        }
        TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, timeout);
        SessionRepository sessionRepository = tenant.getSessionRepository();
        SilentDeployLogger logger = new SilentDeployLogger();
        LocalSession newSession = sessionRepository.createSessionFromExisting(activeSession, true, timeoutBudget);
        return Optional.of(Deployment.unprepared(newSession, this, this.hostProvisioner, tenant, logger, timeout, this.clock, false, bootstrap));
    }

    public Optional<Instant> lastDeployTime(ApplicationId application) {
        Tenant tenant = this.tenantRepository.getTenant(application.tenant());
        if (tenant == null) {
            return Optional.empty();
        }
        RemoteSession activeSession = this.getActiveSession(tenant, application);
        if (activeSession == null) {
            return Optional.empty();
        }
        return Optional.of(activeSession.getCreateTime());
    }

    public ApplicationId activate(Tenant tenant, long sessionId, TimeoutBudget timeoutBudget, boolean force) {
        SilentDeployLogger logger = new SilentDeployLogger();
        Session session = this.getLocalSession(tenant, sessionId);
        Deployment deployment = Deployment.prepared(session, this, this.hostProvisioner, tenant, logger, timeoutBudget.timeout(), this.clock, false, force);
        deployment.activate();
        return session.getApplicationId();
    }

    public Transaction deactivateCurrentActivateNew(Session active, Session prepared, boolean force) {
        Tenant tenant = this.tenantRepository.getTenant(prepared.getTenantName());
        Transaction transaction = tenant.getSessionRepository().createActivateTransaction(prepared);
        if (active != null) {
            ApplicationRepository.checkIfActiveHasChanged(prepared, active, force);
            ApplicationRepository.checkIfActiveIsNewerThanSessionToBeActivated(prepared.getSessionId(), active.getSessionId());
            transaction.add(active.createDeactivateTransaction().operations());
        }
        transaction.add(this.updateMetaDataWithDeployTimestamp(tenant, this.clock.instant()));
        return transaction;
    }

    private List<Transaction.Operation> updateMetaDataWithDeployTimestamp(Tenant tenant, Instant deployTimestamp) {
        TenantMetaData tenantMetaData = this.getTenantMetaData(tenant).withLastDeployTimestamp(deployTimestamp);
        return this.tenantRepository.createWriteTenantMetaDataTransaction(tenantMetaData).operations();
    }

    TenantMetaData getTenantMetaData(Tenant tenant) {
        return this.tenantRepository.getTenantMetaData(tenant);
    }

    static void checkIfActiveHasChanged(Session session, Session activeSession, boolean ignoreStaleSessionFailure) {
        long activeSessionAtCreate = session.getActiveSessionAtCreate();
        log.log(Level.FINE, activeSession.logPre() + "active session id at create time=" + activeSessionAtCreate);
        if (activeSessionAtCreate == 0L) {
            return;
        }
        long sessionId = session.getSessionId();
        long activeSessionSessionId = activeSession.getSessionId();
        log.log(Level.FINE, activeSession.logPre() + "sessionId=" + sessionId + ", current active session=" + activeSessionSessionId);
        if (activeSession.isNewerThan(activeSessionAtCreate) && activeSessionSessionId != sessionId) {
            String errMsg = activeSession.logPre() + "Cannot activate session " + sessionId + " because the currently active session (" + activeSessionSessionId + ") has changed since session " + sessionId + " was created (was " + activeSessionAtCreate + " at creation time)";
            if (ignoreStaleSessionFailure) {
                log.warning(errMsg + " (Continuing because of force.)");
            } else {
                throw new ActivationConflictException(errMsg);
            }
        }
    }

    static void checkIfActiveIsNewerThanSessionToBeActivated(long sessionId, long currentActiveSessionId) {
        if (sessionId < currentActiveSessionId) {
            throw new ActivationConflictException("It is not possible to activate session " + sessionId + ", because it is older than current active session (" + currentActiveSessionId + ")");
        }
    }

    public boolean delete(ApplicationId applicationId) {
        Tenant tenant = this.getTenant(applicationId);
        if (tenant == null) {
            return false;
        }
        TenantApplications tenantApplications = tenant.getApplicationRepo();
        NestedTransaction transaction = new NestedTransaction();
        Optional<ApplicationTransaction> applicationTransaction = this.hostProvisioner.map(provisioner -> provisioner.lock(applicationId)).map(lock -> new ApplicationTransaction(lock, transaction));
        try {
            boolean bl;
            block18: {
                Optional<Long> activeSession;
                Lock sessionLock;
                block16: {
                    boolean bl2;
                    block17: {
                        sessionLock = tenantApplications.lock(applicationId);
                        try {
                            activeSession = tenantApplications.activeSessionOf(applicationId);
                            if (!activeSession.isEmpty()) break block16;
                            bl2 = false;
                            if (sessionLock == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (sessionLock != null) {
                                try {
                                    sessionLock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        sessionLock.close();
                    }
                    return bl2;
                }
                try {
                    RemoteSession session = this.getRemoteSession(tenant, activeSession.get());
                    transaction.add(tenant.getSessionRepository().createSetStatusTransaction(session, Session.Status.DELETE), new Class[0]);
                }
                catch (NotFoundException e) {
                    log.log(Level.INFO, TenantRepository.logPre(applicationId) + "Active session exists, but has not been deleted properly. Trying to cleanup");
                }
                Curator curator = this.tenantRepository.getCurator();
                transaction.add((Transaction)new ContainerEndpointsCache(tenant.getPath(), curator).delete(applicationId), new Class[0]);
                transaction.add((Transaction)new ApplicationRolesStore(curator, tenant.getPath()).delete(applicationId), new Class[0]);
                transaction.add((Transaction)new EndpointCertificateMetadataStore(curator, tenant.getPath()).delete(applicationId), new Class[0]);
                transaction.add((Transaction)tenantApplications.createDeleteTransaction(applicationId), new Class[0]);
                transaction.onCommitted(() -> log.log(Level.INFO, "Deleted " + applicationId));
                if (applicationTransaction.isPresent()) {
                    this.hostProvisioner.get().remove(applicationTransaction.get());
                    applicationTransaction.get().nested().commit();
                } else {
                    transaction.commit();
                }
                bl = true;
                if (sessionLock == null) break block18;
                sessionLock.close();
            }
            return bl;
        }
        finally {
            applicationTransaction.ifPresent(ApplicationTransaction::close);
        }
    }

    public HttpResponse clusterControllerStatusPage(ApplicationId applicationId, String hostName, String pathSuffix) {
        String relativePath = "clustercontroller-status/" + pathSuffix;
        return this.httpProxy.get(this.getApplication(applicationId), hostName, ContainerServiceType.CLUSTERCONTROLLER_CONTAINER.serviceName, relativePath);
    }

    public Map<String, ClusterReindexing> getClusterReindexingStatus(ApplicationId applicationId) {
        return (Map)Exceptions.uncheck(() -> this.clusterReindexingStatusClient.getReindexingStatus(this.getApplication(applicationId)));
    }

    public Long getApplicationGeneration(ApplicationId applicationId) {
        return this.getApplication(applicationId).getApplicationGeneration();
    }

    public void restart(ApplicationId applicationId, HostFilter hostFilter) {
        this.hostProvisioner.ifPresent(provisioner -> provisioner.restart(applicationId, hostFilter));
    }

    public boolean isSuspended(ApplicationId application) {
        return this.orchestrator.getAllSuspendedApplications().contains(application);
    }

    public HttpResponse filedistributionStatus(ApplicationId applicationId, Duration timeout) {
        return this.fileDistributionStatus.status(this.getApplication(applicationId), timeout);
    }

    public List<String> deleteUnusedFiledistributionReferences(File fileReferencesPath, Duration keepFileReferences) {
        log.log(Level.FINE, "Keep unused file references for " + keepFileReferences);
        if (!fileReferencesPath.isDirectory()) {
            throw new RuntimeException(fileReferencesPath + " is not a directory");
        }
        Set<String> fileReferencesInUse = this.getFileReferencesInUse();
        log.log(Level.FINE, "File references in use : " + fileReferencesInUse);
        List<String> candidates = this.sortedUnusedFileReferences(fileReferencesPath, fileReferencesInUse, keepFileReferences);
        List<String> fileReferencesToDelete = candidates.subList(0, Math.max(0, candidates.size() - 5));
        if (fileReferencesToDelete.size() > 0) {
            log.log(Level.FINE, "Will delete file references not in use: " + fileReferencesToDelete);
            fileReferencesToDelete.forEach(fileReference -> {
                File file = new File(fileReferencesPath, (String)fileReference);
                if (!IOUtils.recursiveDeleteDir((File)file)) {
                    log.log(Level.WARNING, "Could not delete " + file.getAbsolutePath());
                }
            });
        }
        return fileReferencesToDelete;
    }

    private Set<String> getFileReferencesInUse() {
        HashSet<String> fileReferencesInUse = new HashSet<String>();
        for (ApplicationId applicationId : this.listApplications()) {
            try {
                Optional<Application> app = this.getOptionalApplication(applicationId);
                if (app.isEmpty()) continue;
                fileReferencesInUse.addAll(app.get().getModel().fileReferences().stream().map(FileReference::value).collect(Collectors.toSet()));
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Getting file references in use for '" + applicationId + "' failed", e);
            }
        }
        return fileReferencesInUse;
    }

    private List<String> sortedUnusedFileReferences(File fileReferencesPath, Set<String> fileReferencesInUse, Duration keepFileReferences) {
        Set<String> fileReferencesOnDisk = FileDistributionUtil.getFileReferencesOnDisk(fileReferencesPath);
        log.log(Level.INFO, "File references on disk (in " + fileReferencesPath + "): " + fileReferencesOnDisk);
        Instant instant = Instant.now().minus(keepFileReferences);
        return fileReferencesOnDisk.stream().filter(fileReference -> !fileReferencesInUse.contains(fileReference)).filter(fileReference -> this.isFileLastModifiedBefore(new File(fileReferencesPath, (String)fileReference), instant)).sorted((a, b) -> this.lastModified(new File(fileReferencesPath, (String)a)).isBefore(this.lastModified(new File(fileReferencesPath, (String)b))) ? -1 : 1).collect(Collectors.toList());
    }

    public Set<FileReference> getFileReferences(ApplicationId applicationId) {
        return this.getOptionalApplication(applicationId).map(app -> app.getModel().fileReferences()).orElse(Set.of());
    }

    public ApplicationFile getApplicationFileFromSession(TenantName tenantName, long sessionId, String path, Session.Mode mode) {
        Tenant tenant = this.tenantRepository.getTenant(tenantName);
        return this.getLocalSession(tenant, sessionId).getApplicationFile(Path.fromString((String)path), mode);
    }

    public Tenant getTenant(ApplicationId applicationId) {
        return this.tenantRepository.getTenant(applicationId.tenant());
    }

    Application getApplication(ApplicationId applicationId) {
        return this.getApplication(applicationId, Optional.empty());
    }

    private Application getApplication(ApplicationId applicationId, Optional<Version> version) {
        try {
            Tenant tenant = this.getTenant(applicationId);
            if (tenant == null) {
                throw new NotFoundException("Tenant '" + applicationId.tenant() + "' not found");
            }
            long sessionId = this.getSessionIdForApplication(tenant, applicationId);
            RemoteSession session = this.getRemoteSession(tenant, sessionId);
            SessionRepository sessionRepository = tenant.getSessionRepository();
            return sessionRepository.ensureApplicationLoaded(session).getForVersionOrLatest(version, this.clock.instant());
        }
        catch (NotFoundException e) {
            log.log(Level.WARNING, "Failed getting application for '" + applicationId + "': " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed getting application for '" + applicationId + "'", e);
            throw e;
        }
    }

    private Optional<Application> getOptionalApplication(ApplicationId applicationId) {
        try {
            return Optional.of(this.getApplication(applicationId));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<ApplicationId> listApplications() {
        return this.tenantRepository.getAllTenants().stream().flatMap(tenant -> tenant.getApplicationRepo().activeApplications().stream()).collect(Collectors.toList());
    }

    private boolean isFileLastModifiedBefore(File fileReference, Instant instant) {
        return this.lastModified(fileReference).isBefore(instant);
    }

    private Instant lastModified(File fileReference) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(fileReference.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.lastModifiedTime().toInstant();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Optional<String> getApplicationPackageReference(ApplicationId applicationId) {
        Optional<String> applicationPackage = Optional.empty();
        Session session = this.getActiveSession(applicationId);
        if (session != null) {
            FileReference applicationPackageReference = session.getApplicationPackageReference();
            File downloadDirectory = new File(Defaults.getDefaults().underVespaHome(this.configserverConfig().fileReferencesDir()));
            if (applicationPackageReference != null && !FileDistributionUtil.fileReferenceExistsOnDisk(downloadDirectory, applicationPackageReference)) {
                applicationPackage = Optional.of(applicationPackageReference.value());
            }
        }
        return applicationPackage;
    }

    public List<Version> getAllVersions(ApplicationId applicationId) {
        Optional<ApplicationSet> applicationSet = this.getActiveApplicationSet(applicationId);
        return applicationSet.isEmpty() ? List.of() : applicationSet.get().getAllVersions(applicationId);
    }

    public HttpResponse validateSecretStore(ApplicationId applicationId, SystemName systemName, Slime slime) {
        Application application = this.getApplication(applicationId);
        return this.secretStoreValidator.validateSecretStore(application, systemName, slime);
    }

    public HttpResponse checkServiceForConfigConvergence(ApplicationId applicationId, String hostAndPort, URI uri, Duration timeout, Optional<Version> vespaVersion) {
        return this.convergeChecker.getServiceConfigGenerationResponse(this.getApplication(applicationId, vespaVersion), hostAndPort, uri, timeout);
    }

    public HttpResponse servicesToCheckForConfigConvergence(ApplicationId applicationId, URI uri, Duration timeoutPerService, Optional<Version> vespaVersion) {
        return this.convergeChecker.getServiceConfigGenerationsResponse(this.getApplication(applicationId, vespaVersion), uri, timeoutPerService);
    }

    public HttpResponse getLogs(ApplicationId applicationId, Optional<String> hostname, String apiParams) {
        String logServerURI = this.getLogServerURI(applicationId, hostname) + apiParams;
        return this.logRetriever.getLogs(logServerURI);
    }

    public HttpResponse getTesterStatus(ApplicationId applicationId) {
        return this.testerClient.getStatus(this.getTesterHostname(applicationId), this.getTesterPort(applicationId));
    }

    public HttpResponse getTesterLog(ApplicationId applicationId, Long after) {
        return this.testerClient.getLog(this.getTesterHostname(applicationId), this.getTesterPort(applicationId), after);
    }

    public HttpResponse startTests(ApplicationId applicationId, String suite, byte[] config) {
        return this.testerClient.startTests(this.getTesterHostname(applicationId), this.getTesterPort(applicationId), suite, config);
    }

    public HttpResponse isTesterReady(ApplicationId applicationId) {
        return this.testerClient.isTesterReady(this.getTesterHostname(applicationId), this.getTesterPort(applicationId));
    }

    public HttpResponse getTestReport(ApplicationId applicationId) {
        return this.testerClient.getReport(this.getTesterHostname(applicationId), this.getTesterPort(applicationId));
    }

    private String getTesterHostname(ApplicationId applicationId) {
        return this.getTesterServiceInfo(applicationId).getHostName();
    }

    private int getTesterPort(ApplicationId applicationId) {
        ServiceInfo serviceInfo = this.getTesterServiceInfo(applicationId);
        return serviceInfo.getPorts().stream().filter(portInfo -> portInfo.getTags().contains("http")).findFirst().get().getPort();
    }

    private ServiceInfo getTesterServiceInfo(ApplicationId applicationId) {
        Application application = this.getApplication(applicationId);
        return ((HostInfo)application.getModel().getHosts().stream().findFirst().orElseThrow(() -> new InternalServerException("Could not find any host for tester app " + applicationId.toFullString()))).getServices().stream().filter(service -> ContainerServiceType.CONTAINER.serviceName.equals(service.getServiceType())).findFirst().orElseThrow(() -> new InternalServerException("Could not find any tester container for tester app " + applicationId.toFullString()));
    }

    public Activation activate(Session session, ApplicationId applicationId, Tenant tenant, boolean force) {
        NestedTransaction transaction = new NestedTransaction();
        Optional<ApplicationTransaction> applicationTransaction = this.hostProvisioner.map(provisioner -> provisioner.lock(applicationId)).map(lock -> new ApplicationTransaction(lock, transaction));
        try {
            Activation activation;
            block11: {
                Lock sessionLock = tenant.getApplicationRepo().lock(applicationId);
                try {
                    Session activeSession = this.getActiveSession(applicationId);
                    Curator.CompletionWaiter waiter = session.getSessionZooKeeperClient().createActiveWaiter();
                    transaction.add(this.deactivateCurrentActivateNew(activeSession, session, force), new Class[0]);
                    if (applicationTransaction.isPresent()) {
                        this.hostProvisioner.get().activate((Collection)session.getAllocatedHosts().getHosts(), new ActivationContext(session.getSessionId()), applicationTransaction.get());
                        applicationTransaction.get().nested().commit();
                    } else {
                        transaction.commit();
                    }
                    activation = new Activation(waiter, activeSession);
                    if (sessionLock == null) break block11;
                }
                catch (Throwable throwable) {
                    if (sessionLock != null) {
                        try {
                            sessionLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sessionLock.close();
            }
            return activation;
        }
        finally {
            applicationTransaction.ifPresent(ApplicationTransaction::close);
        }
    }

    public Session getActiveSession(ApplicationId applicationId) {
        return this.getActiveRemoteSession(applicationId);
    }

    public RemoteSession getActiveRemoteSession(ApplicationId applicationId) {
        Tenant tenant = this.getTenant(applicationId);
        if (tenant == null) {
            throw new IllegalArgumentException("Could not find any tenant for '" + applicationId + "'");
        }
        return this.getActiveSession(tenant, applicationId);
    }

    public long getSessionIdForApplication(ApplicationId applicationId) {
        Tenant tenant = this.getTenant(applicationId);
        if (tenant == null) {
            throw new NotFoundException("Tenant '" + applicationId.tenant() + "' not found");
        }
        return this.getSessionIdForApplication(tenant, applicationId);
    }

    private long getSessionIdForApplication(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        if (!applicationRepo.exists(applicationId)) {
            throw new NotFoundException("Unknown application id '" + applicationId + "'");
        }
        return applicationRepo.requireActiveSessionOf(applicationId);
    }

    public void validateThatSessionIsNotActive(Tenant tenant, long sessionId) {
        RemoteSession session = this.getRemoteSession(tenant, sessionId);
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session is active: " + sessionId);
        }
    }

    public void validateThatSessionIsPrepared(Tenant tenant, long sessionId) {
        RemoteSession session = this.getRemoteSession(tenant, sessionId);
        if (!Session.Status.PREPARE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session not prepared: " + sessionId);
        }
    }

    public long createSessionFromExisting(ApplicationId applicationId, boolean internalRedeploy, TimeoutBudget timeoutBudget) {
        Tenant tenant = this.getTenant(applicationId);
        SessionRepository sessionRepository = tenant.getSessionRepository();
        Session fromSession = this.getExistingSession(tenant, applicationId);
        LocalSession session = sessionRepository.createSessionFromExisting(fromSession, internalRedeploy, timeoutBudget);
        return session.getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createSession(ApplicationId applicationId, TimeoutBudget timeoutBudget, InputStream in, String contentType, DeployLogger logger) {
        long sessionId;
        File tempDir = ((java.nio.file.Path)Exceptions.uncheck(() -> Files.createTempDirectory("deploy", new FileAttribute[0]))).toFile();
        try {
            sessionId = this.createSession(applicationId, timeoutBudget, this.decompressApplication(in, contentType, tempDir));
        }
        finally {
            this.cleanupTempDirectory(tempDir, logger);
        }
        return sessionId;
    }

    public long createSession(ApplicationId applicationId, TimeoutBudget timeoutBudget, File applicationDirectory) {
        SessionRepository sessionRepository = this.getTenant(applicationId).getSessionRepository();
        LocalSession session = sessionRepository.createSessionFromApplicationPackage(applicationDirectory, applicationId, timeoutBudget);
        return session.getSessionId();
    }

    public void deleteExpiredLocalSessions() {
        HashMap sessionsPerTenant = new HashMap();
        this.tenantRepository.getAllTenants().forEach(tenant -> sessionsPerTenant.put(tenant, tenant.getSessionRepository().getLocalSessions()));
        HashSet applicationIds = new HashSet();
        sessionsPerTenant.values().forEach(sessionList -> sessionList.stream().map(Session::getOptionalApplicationId).filter(Optional::isPresent).forEach(appId -> applicationIds.add((ApplicationId)appId.get())));
        HashMap activeSessions = new HashMap();
        applicationIds.forEach(applicationId -> {
            Session activeSession = this.getActiveSession((ApplicationId)applicationId);
            if (activeSession != null) {
                activeSessions.put(applicationId, activeSession.getSessionId());
            }
        });
        sessionsPerTenant.keySet().forEach(tenant -> tenant.getSessionRepository().deleteExpiredSessions(activeSessions));
    }

    public int deleteExpiredRemoteSessions(Duration expiryTime) {
        return this.deleteExpiredRemoteSessions(this.clock, expiryTime);
    }

    public int deleteExpiredRemoteSessions(Clock clock, Duration expiryTime) {
        return this.tenantRepository.getAllTenants().stream().map(tenant -> tenant.getSessionRepository().deleteExpiredRemoteSessions(clock, expiryTime)).mapToInt(i -> i).sum();
    }

    public TenantRepository tenantRepository() {
        return this.tenantRepository;
    }

    public Set<TenantName> deleteUnusedTenants(Duration ttlForUnusedTenant, Instant now) {
        return this.tenantRepository.getAllTenantNames().stream().filter(tenantName -> this.activeApplications((TenantName)tenantName).isEmpty()).filter(tenantName -> !tenantName.equals((Object)TenantName.defaultName())).filter(tenantName -> !tenantName.equals((Object)TenantRepository.HOSTED_VESPA_TENANT)).filter(tenantName -> this.getTenantMetaData(this.tenantRepository.getTenant((TenantName)tenantName)).lastDeployTimestamp().isBefore(now.minus(ttlForUnusedTenant))).peek(this.tenantRepository::deleteTenant).collect(Collectors.toSet());
    }

    public void deleteTenant(TenantName tenantName) {
        List<ApplicationId> activeApplications = this.activeApplications(tenantName);
        if (!activeApplications.isEmpty()) {
            throw new IllegalArgumentException("Cannot delete tenant '" + tenantName + "', it has active applications: " + activeApplications);
        }
        this.tenantRepository.deleteTenant(tenantName);
    }

    private List<ApplicationId> activeApplications(TenantName tenantName) {
        return this.tenantRepository.getTenant(tenantName).getApplicationRepo().activeApplications();
    }

    public ProtonMetricsResponse getProtonMetrics(ApplicationId applicationId) {
        Application application = this.getApplication(applicationId);
        ProtonMetricsRetriever protonMetricsRetriever = new ProtonMetricsRetriever();
        return protonMetricsRetriever.getMetrics(application);
    }

    public DeploymentMetricsResponse getDeploymentMetrics(ApplicationId applicationId) {
        Application application = this.getApplication(applicationId);
        DeploymentMetricsRetriever deploymentMetricsRetriever = new DeploymentMetricsRetriever();
        return deploymentMetricsRetriever.getMetrics(application);
    }

    public ApplicationMetaData getMetadataFromLocalSession(Tenant tenant, long sessionId) {
        return this.getLocalSession(tenant, sessionId).getMetaData();
    }

    private ApplicationCuratorDatabase requireDatabase(ApplicationId id) {
        Tenant tenant = this.getTenant(id);
        if (tenant == null) {
            throw new NotFoundException("Tenant '" + id.tenant().value() + "' not found");
        }
        return tenant.getApplicationRepo().database();
    }

    public ApplicationReindexing getReindexing(ApplicationId id) {
        return this.requireDatabase(id).readReindexingStatus(id).orElseThrow(() -> new NotFoundException("Reindexing status not found for " + id));
    }

    public void modifyReindexing(ApplicationId id, UnaryOperator<ApplicationReindexing> modifications) {
        Tenant tenant = this.getTenant(id);
        if (tenant == null) {
            throw new NotFoundException("Tenant '" + id.tenant().value() + "' not found");
        }
        tenant.getApplicationRepo().database().modifyReindexing(id, ApplicationReindexing.empty(), modifications);
    }

    public ConfigserverConfig configserverConfig() {
        return this.configserverConfig;
    }

    public ApplicationId getApplicationIdForHostname(String hostname) {
        Optional<ApplicationId> applicationId = this.tenantRepository.getAllTenantNames().stream().map(tenantName -> this.tenantRepository.getTenant((TenantName)tenantName).getApplicationRepo().getApplicationIdForHostName(hostname)).filter(Objects::nonNull).findFirst();
        return applicationId.orElse(null);
    }

    private Session validateThatLocalSessionIsNotActive(Tenant tenant, long sessionId) {
        Session session = this.getLocalSession(tenant, sessionId);
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session is active: " + sessionId);
        }
        return session;
    }

    private Session getLocalSession(Tenant tenant, long sessionId) {
        LocalSession session = tenant.getSessionRepository().getLocalSession(sessionId);
        if (session == null) {
            throw new NotFoundException("Session " + sessionId + " was not found");
        }
        return session;
    }

    private RemoteSession getRemoteSession(Tenant tenant, long sessionId) {
        RemoteSession session = tenant.getSessionRepository().getRemoteSession(sessionId);
        if (session == null) {
            throw new NotFoundException("Session " + sessionId + " was not found");
        }
        return session;
    }

    public Optional<ApplicationSet> getActiveApplicationSet(ApplicationId appId) {
        return this.getTenant(appId).getSessionRepository().getActiveApplicationSet(appId);
    }

    private File decompressApplication(InputStream in, String contentType, File tempDir) {
        File file;
        block8: {
            CompressedApplicationInputStream application = CompressedApplicationInputStream.createFromCompressedStream(in, contentType);
            try {
                file = this.decompressApplication(application, tempDir);
                if (application == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (application != null) {
                        try {
                            application.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to decompress data in body", e);
                }
            }
            application.close();
        }
        return file;
    }

    private File decompressApplication(CompressedApplicationInputStream in, File tempDir) {
        try {
            return in.decompress(tempDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to decompress stream", e);
        }
    }

    private void cleanupTempDirectory(File tempDir, DeployLogger logger) {
        if (!IOUtils.recursiveDeleteDir((File)tempDir)) {
            logger.log(Level.WARNING, "Not able to delete tmp dir '" + tempDir + "'");
        }
    }

    private Session getExistingSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        return this.getRemoteSession(tenant, applicationRepo.requireActiveSessionOf(applicationId));
    }

    public RemoteSession getActiveSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        if (applicationRepo.activeApplications().contains(applicationId)) {
            return tenant.getSessionRepository().getRemoteSession(applicationRepo.requireActiveSessionOf(applicationId));
        }
        return null;
    }

    public Session getActiveLocalSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        if (applicationRepo.activeApplications().contains(applicationId)) {
            return tenant.getSessionRepository().getLocalSession(applicationRepo.requireActiveSessionOf(applicationId));
        }
        return null;
    }

    public double getQuotaUsageRate(ApplicationId applicationId) {
        Application application = this.getApplication(applicationId);
        return application.getModel().provisioned().all().values().stream().map(Capacity::maxResources).mapToDouble(resources -> (double)resources.nodes() * resources.nodeResources().cost()).sum();
    }

    public Duration serverDeployTimeout() {
        return Duration.ofSeconds(this.configserverConfig.zookeeper().barrierTimeout());
    }

    public void setDedicatedClusterControllerCluster(ApplicationId id) {
        this.requireDatabase(id).setDedicatedClusterControllerCluster(id);
    }

    public boolean getDedicatedClusterControllerCluster(ApplicationId id) {
        return this.requireDatabase(id).getDedicatedClusterControllerCluster(id);
    }

    private static void logConfigChangeActions(ConfigChangeActions actions, DeployLogger logger) {
        ReindexActions reindexActions;
        RefeedActions refeedActions;
        RestartActions restartActions = actions.getRestartActions();
        if (!restartActions.isEmpty()) {
            logger.log(Level.WARNING, "Change(s) between active and new application that require restart:\n" + restartActions.format());
        }
        if (!(refeedActions = actions.getRefeedActions()).isEmpty()) {
            logger.log(Level.WARNING, "Change(s) between active and new application that may require re-feed:\n" + refeedActions.format());
        }
        if (!(reindexActions = actions.getReindexActions()).isEmpty()) {
            logger.log(Level.WARNING, "Change(s) between active and new application that may require re-index:\n" + reindexActions.format());
        }
    }

    private String getLogServerURI(ApplicationId applicationId, Optional<String> hostname) {
        if (hostname.isPresent() && TenantRepository.HOSTED_VESPA_TENANT.equals((Object)applicationId.tenant())) {
            int port = List.of("zone-config-servers", "controller").contains(applicationId.application().value()) ? 19071 : 8080;
            return "http://" + hostname.get() + ":" + port + "/logs";
        }
        Application application = this.getApplication(applicationId);
        Collection hostInfos = application.getModel().getHosts();
        HostInfo logServerHostInfo = hostInfos.stream().filter(host -> host.getServices().stream().anyMatch(serviceInfo -> serviceInfo.getServiceType().equalsIgnoreCase("logserver"))).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find host info for logserver"));
        ServiceInfo serviceInfo = logServerHostInfo.getServices().stream().filter(service -> List.of(ContainerServiceType.LOGSERVER_CONTAINER.serviceName, ContainerServiceType.CONTAINER.serviceName).contains(service.getServiceType())).findFirst().orElseThrow(() -> new IllegalArgumentException("No container running on logserver host"));
        int port = this.servicePort(serviceInfo);
        return "http://" + logServerHostInfo.getHostname() + ":" + port + "/logs";
    }

    private int servicePort(ServiceInfo serviceInfo) {
        return serviceInfo.getPorts().stream().filter(portInfo -> portInfo.getTags().stream().anyMatch(tag -> tag.equalsIgnoreCase("http"))).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find HTTP port")).getPort();
    }

    public Zone zone() {
        return new Zone(SystemName.from((String)this.configserverConfig.system()), Environment.from((String)this.configserverConfig.environment()), RegionName.from((String)this.configserverConfig.region()));
    }

    public Clock clock() {
        return this.clock;
    }

    public ActionTimer timerFor(ApplicationId id, String metricName) {
        return new ActionTimer(this.metric, this.clock, id, this.configserverConfig.environment(), this.configserverConfig.region(), metricName);
    }

    public static class Activation {
        private final Curator.CompletionWaiter waiter;
        private final OptionalLong sourceSessionId;

        public Activation(Curator.CompletionWaiter waiter, Session sourceSession) {
            this.waiter = waiter;
            this.sourceSessionId = sourceSession == null ? OptionalLong.empty() : OptionalLong.of(sourceSession.getSessionId());
        }

        public void awaitCompletion(Duration timeout) {
            this.waiter.awaitCompletion(timeout);
        }

        public OptionalLong sourceSessionId() {
            return this.sourceSessionId;
        }
    }

    public static class ActionTimer
    implements AutoCloseable {
        private final Metric metric;
        private final Clock clock;
        private final ApplicationId id;
        private final String environment;
        private final String region;
        private final String name;
        private final Instant start;

        private ActionTimer(Metric metric, Clock clock, ApplicationId id, String environment, String region, String name) {
            this.metric = metric;
            this.clock = clock;
            this.id = id;
            this.environment = environment;
            this.region = region;
            this.name = name;
            this.start = clock.instant();
        }

        @Override
        public void close() {
            this.metric.set(this.name, (Number)Duration.between(this.start, this.clock.instant()).toMillis(), this.metric.createContext(Map.of("applicationId", this.id.toFullString(), "tenantName", this.id.tenant().value(), "app", this.id.application().value() + "." + this.id.instance().value(), "zone", this.environment + "." + this.region)));
        }
    }

    public static class Builder {
        private TenantRepository tenantRepository;
        private Optional<Provisioner> hostProvisioner;
        private HttpProxy httpProxy = new HttpProxy(new SimpleHttpFetcher());
        private Clock clock = Clock.systemUTC();
        private ConfigserverConfig configserverConfig = new ConfigserverConfig.Builder().build();
        private Orchestrator orchestrator;
        private LogRetriever logRetriever = new LogRetriever();
        private TesterClient testerClient = new TesterClient();
        private Metric metric = new NullMetric();
        private SecretStoreValidator secretStoreValidator = new SecretStoreValidator(new SecretStoreProvider().get());
        private FlagSource flagSource = new InMemoryFlagSource();

        public Builder withTenantRepository(TenantRepository tenantRepository) {
            this.tenantRepository = tenantRepository;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withProvisioner(Provisioner provisioner) {
            if (this.hostProvisioner != null) {
                throw new IllegalArgumentException("provisioner already set in builder");
            }
            this.hostProvisioner = Optional.ofNullable(provisioner);
            return this;
        }

        public Builder withHostProvisionerProvider(HostProvisionerProvider hostProvisionerProvider) {
            if (this.hostProvisioner != null) {
                throw new IllegalArgumentException("provisioner already set in builder");
            }
            this.hostProvisioner = hostProvisionerProvider.getHostProvisioner();
            return this;
        }

        public Builder withHttpProxy(HttpProxy httpProxy) {
            this.httpProxy = httpProxy;
            return this;
        }

        public Builder withConfigserverConfig(ConfigserverConfig configserverConfig) {
            this.configserverConfig = configserverConfig;
            return this;
        }

        public Builder withOrchestrator(Orchestrator orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        public Builder withLogRetriever(LogRetriever logRetriever) {
            this.logRetriever = logRetriever;
            return this;
        }

        public Builder withTesterClient(TesterClient testerClient) {
            this.testerClient = testerClient;
            return this;
        }

        public Builder withFlagSource(FlagSource flagSource) {
            this.flagSource = flagSource;
            return this;
        }

        public Builder withMetric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public Builder withSecretStoreValidator(SecretStoreValidator secretStoreValidator) {
            this.secretStoreValidator = secretStoreValidator;
            return this;
        }

        public ApplicationRepository build() {
            return new ApplicationRepository(this.tenantRepository, this.hostProvisioner, InfraDeployerProvider.empty().getInfraDeployer(), new ConfigConvergenceChecker(), this.httpProxy, this.configserverConfig, this.orchestrator, this.logRetriever, this.clock, this.testerClient, this.metric, this.secretStoreValidator, ClusterReindexingStatusClient.DUMMY_INSTANCE);
        }
    }
}

