/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterReindexing {
    private static final ClusterReindexing empty = new ClusterReindexing(Map.of());
    private final Map<String, Status> documentTypeStatus;

    public ClusterReindexing(Map<String, Status> documentTypeStatus) {
        this.documentTypeStatus = Map.copyOf(documentTypeStatus);
    }

    public static ClusterReindexing empty() {
        return empty;
    }

    public Map<String, Status> documentTypeStatus() {
        return this.documentTypeStatus;
    }

    public static enum State {
        PENDING,
        RUNNING,
        FAILED,
        SUCCESSFUL;

    }

    public static class Status {
        private final Instant startedAt;
        private final Instant endedAt;
        private final State state;
        private final String message;
        private final String progress;

        public Status(Instant startedAt, Instant endedAt, State state, String message, String progress) {
            this.startedAt = Objects.requireNonNull(startedAt);
            this.endedAt = endedAt;
            this.state = state;
            this.message = message;
            this.progress = progress;
        }

        public Instant startedAt() {
            return this.startedAt;
        }

        public Optional<Instant> endedAt() {
            return Optional.ofNullable(this.endedAt);
        }

        public Optional<State> state() {
            return Optional.ofNullable(this.state);
        }

        public Optional<String> message() {
            return Optional.ofNullable(this.message);
        }

        public Optional<String> progress() {
            return Optional.ofNullable(this.progress);
        }
    }
}

