/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.component.Version;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.server.ServerCache;
import com.yahoo.vespa.config.server.UnknownConfigDefinitionException;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import com.yahoo.vespa.config.server.rpc.UncompressedConfigResponseFactory;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Application
implements ModelResult {
    private static final Logger log = Logger.getLogger(Application.class.getName());
    private final long applicationGeneration;
    private final boolean internalRedeploy;
    private final Version vespaVersion;
    private final Model model;
    private final ServerCache cache;
    private final MetricUpdater metricUpdater;
    private final ApplicationId app;

    public Application(Model model, ServerCache cache, long applicationGeneration, boolean internalRedeploy, Version vespaVersion, MetricUpdater metricUpdater, ApplicationId app) {
        Objects.requireNonNull(model, "The model cannot be null");
        this.model = model;
        this.cache = cache;
        this.applicationGeneration = applicationGeneration;
        this.internalRedeploy = internalRedeploy;
        this.vespaVersion = vespaVersion;
        this.metricUpdater = metricUpdater;
        this.app = app;
    }

    public Long getApplicationGeneration() {
        return this.applicationGeneration;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("application '").append(this.app.application().value()).append("', ");
        sb.append("generation ").append(this.applicationGeneration).append(", ");
        sb.append("vespa version ").append(this.vespaVersion);
        return sb.toString();
    }

    public ApplicationInfo toApplicationInfo() {
        return new ApplicationInfo(this.app, this.applicationGeneration, this.model);
    }

    public ServerCache getCache() {
        return this.cache;
    }

    public ApplicationId getId() {
        return this.app;
    }

    public Version getVespaVersion() {
        return this.vespaVersion;
    }

    public ConfigResponse resolveConfig(GetConfigRequest req, ConfigResponseFactory responseFactory) {
        ConfigResponse config;
        long start = System.currentTimeMillis();
        this.metricUpdater.incrementRequests();
        ConfigKey configKey = req.getConfigKey();
        String defMd5 = configKey.getMd5();
        if (defMd5 == null || defMd5.isEmpty()) {
            defMd5 = ConfigUtils.getDefMd5((List)req.getDefContent().asList());
        }
        ConfigCacheKey cacheKey = new ConfigCacheKey(configKey, defMd5);
        if (this.logDebug()) {
            this.debug("Resolving config " + cacheKey);
        }
        if (this.useCache(req) && (config = this.cache.get(cacheKey)) != null) {
            if (this.logDebug()) {
                this.debug("Found config " + cacheKey + " in cache");
            }
            this.metricUpdater.incrementProcTime(System.currentTimeMillis() - start);
            return config;
        }
        ConfigDefinition def = this.getTargetDef(req);
        if (def == null) {
            this.metricUpdater.incrementFailedRequests();
            throw new UnknownConfigDefinitionException("Unable to find config definition for '" + configKey.getNamespace() + "." + configKey.getName());
        }
        if (this.logDebug()) {
            this.debug("Resolving " + configKey + " with config definition " + def);
        }
        ConfigPayload payload = null;
        try {
            payload = this.model.getConfig(configKey, def);
        }
        catch (Exception e) {
            throw new ConfigurationRuntimeException("Unable to get config for " + this.app, (Throwable)e);
        }
        if (payload == null) {
            this.metricUpdater.incrementFailedRequests();
            throw new ConfigurationRuntimeException("Unable to resolve config " + configKey);
        }
        ConfigResponse configResponse = responseFactory.createResponse(payload, this.applicationGeneration, this.internalRedeploy);
        this.metricUpdater.incrementProcTime(System.currentTimeMillis() - start);
        if (this.useCache(req)) {
            this.cache.put(cacheKey, configResponse, configResponse.getConfigMd5());
            this.metricUpdater.setCacheConfigElems(this.cache.configElems());
            this.metricUpdater.setCacheChecksumElems(this.cache.checkSumElems());
        }
        return configResponse;
    }

    private boolean useCache(GetConfigRequest request) {
        return !request.noCache();
    }

    private boolean logDebug() {
        return log.isLoggable(Level.FINE);
    }

    private void debug(String message) {
        log.log(Level.FINE, TenantRepository.logPre(this.getId()) + message);
    }

    private ConfigDefinition getTargetDef(GetConfigRequest req) {
        ConfigKey configKey = req.getConfigKey();
        DefContent def = req.getDefContent();
        ConfigDefinitionKey configDefinitionKey = new ConfigDefinitionKey(configKey.getName(), configKey.getNamespace());
        if (def.isEmpty()) {
            if (this.logDebug()) {
                this.debug("No config schema in request for " + configKey);
            }
            return this.cache.getDef(configDefinitionKey);
        }
        if (this.logDebug()) {
            this.debug("Got config schema from request, length:" + def.asList().size() + " : " + configKey);
        }
        return new ConfigDefinition(configKey.getName(), def.asStringArray());
    }

    void updateHostMetrics(int numHosts) {
        this.metricUpdater.setHosts(numHosts);
    }

    ConfigResponse resolveConfig(GetConfigRequest req) {
        return this.resolveConfig(req, new UncompressedConfigResponseFactory());
    }

    public Set<ConfigKey<?>> allConfigsProduced() {
        return this.model.allConfigsProduced();
    }

    public Set<String> allConfigIds() {
        return this.model.allConfigIds();
    }
}

