/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationCuratorDatabase;
import com.yahoo.vespa.config.server.application.ApplicationReindexing;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.yolean.Exceptions;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReindexingMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ReindexingMaintainer.class.getName());
    private static final Duration timeout = Duration.ofSeconds(10L);
    static final Duration reindexingInterval = Duration.ofDays(30L);
    private final ConfigConvergenceChecker convergence;
    private final Clock clock;

    public ReindexingMaintainer(ApplicationRepository applicationRepository, Curator curator, FlagSource flagSource, Duration interval, ConfigConvergenceChecker convergence, Clock clock) {
        super(applicationRepository, curator, flagSource, clock.instant(), interval);
        this.convergence = convergence;
        this.clock = clock;
    }

    protected boolean maintain() {
        AtomicBoolean success = new AtomicBoolean(true);
        for (Tenant tenant : this.applicationRepository.tenantRepository().getAllTenants()) {
            ApplicationCuratorDatabase database = tenant.getApplicationRepo().database();
            for (ApplicationId id : database.activeApplications()) {
                this.applicationRepository.getActiveApplicationSet(id).map(application -> application.getForVersionOrLatest(Optional.empty(), this.clock.instant())).ifPresent(application -> {
                    try (Lock lock = database.lock(id);){
                        ApplicationReindexing reindexing = database.readReindexingStatus(id).orElse(ApplicationReindexing.ready(this.clock.instant()));
                        database.writeReindexingStatus(id, ReindexingMaintainer.withReady(reindexing, this.lazyGeneration((Application)application), this.clock.instant()));
                    }
                    catch (RuntimeException e) {
                        log.log(Level.INFO, "Failed to update reindexing status for " + id + ": " + Exceptions.toMessageString((Throwable)e));
                        success.set(false);
                    }
                });
            }
        }
        return success.get();
    }

    private Supplier<Long> lazyGeneration(Application application) {
        AtomicLong oldest = new AtomicLong();
        return () -> {
            if (oldest.get() == 0L) {
                oldest.set(this.convergence.getServiceConfigGenerations(application, timeout).values().stream().min(Comparator.naturalOrder()).orElse(-1L));
            }
            return oldest.get();
        };
    }

    static ApplicationReindexing withReady(ApplicationReindexing reindexing, Supplier<Long> oldestGeneration, Instant now) {
        for (Map.Entry<String, ApplicationReindexing.Cluster> cluster : reindexing.clusters().entrySet()) {
            for (Map.Entry<String, Long> entry : cluster.getValue().pending().entrySet()) {
                if (entry.getValue() > oldestGeneration.get()) continue;
                reindexing = reindexing.withReady(cluster.getKey(), entry.getKey(), now);
            }
            for (Map.Entry<String, Object> entry : cluster.getValue().ready().entrySet()) {
                if (!((ApplicationReindexing.Status)entry.getValue()).ready().isBefore(now.minus(reindexingInterval))) continue;
                reindexing = reindexing.withReady(cluster.getKey(), entry.getKey(), now);
            }
            if (!cluster.getValue().common().ready().isBefore(now.minus(reindexingInterval))) continue;
            reindexing = reindexing.withReady(cluster.getKey(), now);
        }
        if (reindexing.common().ready().isBefore(now.minus(reindexingInterval))) {
            reindexing = reindexing.withReady(now);
        }
        return reindexing;
    }
}

