/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.ConfigServerBootstrap;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.maintenance.ApplicationPackageMaintainer;
import com.yahoo.vespa.config.server.maintenance.FileDistributionMaintainer;
import com.yahoo.vespa.config.server.maintenance.ReindexingMaintainer;
import com.yahoo.vespa.config.server.maintenance.SessionsMaintainer;
import com.yahoo.vespa.config.server.maintenance.TenantsMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Clock;
import java.time.Duration;

public class ConfigServerMaintenance
extends AbstractComponent {
    private final TenantsMaintainer tenantsMaintainer;
    private final FileDistributionMaintainer fileDistributionMaintainer;
    private final SessionsMaintainer sessionsMaintainer;
    private final ApplicationPackageMaintainer applicationPackageMaintainer;
    private final ReindexingMaintainer reindexingMaintainer;

    @Inject
    public ConfigServerMaintenance(ConfigServerBootstrap configServerBootstrap, ConfigserverConfig configserverConfig, ApplicationRepository applicationRepository, Curator curator, FlagSource flagSource, ConfigConvergenceChecker convergence) {
        DefaultTimes defaults = new DefaultTimes(configserverConfig);
        this.tenantsMaintainer = new TenantsMaintainer(applicationRepository, curator, flagSource, defaults.defaultInterval, Clock.systemUTC());
        this.fileDistributionMaintainer = new FileDistributionMaintainer(applicationRepository, curator, defaults.defaultInterval, flagSource);
        this.sessionsMaintainer = new SessionsMaintainer(applicationRepository, curator, Duration.ofSeconds(30L), flagSource);
        this.applicationPackageMaintainer = new ApplicationPackageMaintainer(applicationRepository, curator, Duration.ofSeconds(30L), flagSource);
        this.reindexingMaintainer = new ReindexingMaintainer(applicationRepository, curator, flagSource, Duration.ofMinutes(30L), convergence, Clock.systemUTC());
    }

    public void deconstruct() {
        this.fileDistributionMaintainer.close();
        this.sessionsMaintainer.close();
        this.applicationPackageMaintainer.close();
        this.tenantsMaintainer.close();
        this.reindexingMaintainer.close();
    }

    private static class DefaultTimes {
        private final Duration defaultInterval;

        DefaultTimes(ConfigserverConfig configserverConfig) {
            this.defaultInterval = Duration.ofMinutes(configserverConfig.maintainerIntervalMinutes());
        }
    }
}

