/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.model.api.Reindexing;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApplicationReindexing
implements Reindexing {
    private final Status common;
    private final Map<String, Cluster> clusters;

    public ApplicationReindexing(Status common, Map<String, Cluster> clusters) {
        this.common = Objects.requireNonNull(common);
        this.clusters = Map.copyOf(clusters);
    }

    public static ApplicationReindexing ready(Instant now) {
        return new ApplicationReindexing(new Status(now), Map.of());
    }

    public ApplicationReindexing withReady(Instant readyAt) {
        return new ApplicationReindexing(new Status(readyAt), this.clusters);
    }

    public ApplicationReindexing withReady(String cluster, Instant readyAt) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.empty);
        Cluster modified = new Cluster(new Status(readyAt), current.pending, current.ready);
        return new ApplicationReindexing(this.common, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing withReady(String cluster, String documentType, Instant readyAt) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.empty);
        Cluster modified = new Cluster(current.common, ApplicationReindexing.without(documentType, current.pending), ApplicationReindexing.with(documentType, new Status(readyAt), current.ready));
        return new ApplicationReindexing(this.common, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing withPending(String cluster, String documentType, long requiredGeneration) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.empty);
        Cluster modified = new Cluster(current.common, ApplicationReindexing.with(documentType, ApplicationReindexing.requirePositive(requiredGeneration), current.pending), ApplicationReindexing.without(documentType, current.ready));
        return new ApplicationReindexing(this.common, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public Status common() {
        return this.common;
    }

    public Map<String, Cluster> clusters() {
        return this.clusters;
    }

    public Optional<Reindexing.Status> status(String cluster, String documentType) {
        if (this.clusters.containsKey(cluster)) {
            if (this.clusters.get(cluster).pending().containsKey(documentType)) {
                return Optional.empty();
            }
            Status documentStatus = this.clusters.get(cluster).ready().get(documentType);
            Status clusterStatus = this.clusters.get(cluster).common();
            if (documentStatus == null || documentStatus.ready().isBefore(clusterStatus.ready())) {
                documentStatus = clusterStatus;
            }
            if (documentStatus.ready().isAfter(this.common().ready())) {
                return Optional.of(documentStatus);
            }
        }
        return Optional.of(this.common());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationReindexing that = (ApplicationReindexing)o;
        return this.common.equals(that.common) && this.clusters.equals(that.clusters);
    }

    public int hashCode() {
        return Objects.hash(this.common, this.clusters);
    }

    public String toString() {
        return "ApplicationReindexing{common=" + this.common + ", clusters=" + this.clusters + "}";
    }

    private static long requirePositive(long generation) {
        if (generation <= 0L) {
            throw new IllegalArgumentException("Generation must be positive, but was " + generation);
        }
        return generation;
    }

    private static <T> Map<String, T> without(String removed, Map<String, T> map) {
        return map.keySet().stream().filter(key -> !removed.equals(key)).collect(Collectors.toUnmodifiableMap(key -> key, key -> map.get(key)));
    }

    private static <T> Map<String, T> with(String added, T value, Map<String, T> map) {
        return Stream.concat(Stream.of(added), map.keySet().stream()).distinct().collect(Collectors.toUnmodifiableMap(key -> key, key -> added.equals(key) ? value : map.get(key)));
    }

    public static class Status
    implements Reindexing.Status {
        private static final Status ALWAYS_READY = new Status(Instant.EPOCH);
        private final Instant ready;

        Status(Instant ready) {
            this.ready = Objects.requireNonNull(ready);
        }

        public Instant ready() {
            return this.ready;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.ready.equals(status.ready);
        }

        public int hashCode() {
            return Objects.hash(this.ready);
        }

        public String toString() {
            return "ready at " + this.ready;
        }
    }

    public static class Cluster {
        private static final Cluster empty = new Cluster(Status.ALWAYS_READY, Map.of(), Map.of());
        private final Status common;
        private final Map<String, Long> pending;
        private final Map<String, Status> ready;

        Cluster(Status common, Map<String, Long> pending, Map<String, Status> ready) {
            this.common = Objects.requireNonNull(common);
            this.pending = Map.copyOf(pending);
            this.ready = Map.copyOf(ready);
        }

        public Status common() {
            return this.common;
        }

        public Map<String, Long> pending() {
            return this.pending;
        }

        public Map<String, Status> ready() {
            return this.ready;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cluster cluster = (Cluster)o;
            return this.common.equals(cluster.common) && this.pending.equals(cluster.pending) && this.ready.equals(cluster.ready);
        }

        public int hashCode() {
            return Objects.hash(this.common, this.pending, this.ready);
        }

        public String toString() {
            return "Cluster{common=" + this.common + ", pending=" + this.pending + ", ready=" + this.ready + "}";
        }
    }
}

