/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.model.api.Reindexing;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReindexingStatus
implements Reindexing {
    private static final ReindexingStatus empty = new ReindexingStatus(Map.of(), Map.of());
    private final Map<String, Long> pending;
    private final Map<String, Status> ready;

    ReindexingStatus(Map<String, Long> pending, Map<String, Status> ready) {
        this.pending = Map.copyOf(pending);
        this.ready = Map.copyOf(ready);
    }

    public static ReindexingStatus empty() {
        return empty;
    }

    public ReindexingStatus withPending(String documentType, long requiredGeneration) {
        return new ReindexingStatus(ReindexingStatus.with(documentType, ReindexingStatus.requirePositive(requiredGeneration), this.pending), ReindexingStatus.without(documentType, this.ready));
    }

    public ReindexingStatus withReady(String documentType, Instant readyAt) {
        return new ReindexingStatus(ReindexingStatus.without(documentType, this.pending), ReindexingStatus.with(documentType, new Status(readyAt), this.ready));
    }

    public Map<String, Long> pending() {
        return this.pending;
    }

    public Map<String, ? extends Reindexing.Status> status() {
        return this.ready;
    }

    private static long requirePositive(long generation) {
        if (generation <= 0L) {
            throw new IllegalArgumentException("Generation must be positive, but was " + generation);
        }
        return generation;
    }

    private static <T> Map<String, T> without(String removed, Map<String, T> map) {
        return map.keySet().stream().filter(key -> !removed.equals(key)).collect(Collectors.toUnmodifiableMap(key -> key, key -> map.get(key)));
    }

    private static <T> Map<String, T> with(String added, T value, Map<String, T> map) {
        return Stream.concat(Stream.of(added), map.keySet().stream()).distinct().collect(Collectors.toUnmodifiableMap(key -> key, key -> added.equals(key) ? value : map.get(key)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReindexingStatus that = (ReindexingStatus)o;
        return this.pending.equals(that.pending) && this.ready.equals(that.ready);
    }

    public int hashCode() {
        return Objects.hash(this.pending, this.ready);
    }

    public String toString() {
        return "ReindexingStatus{pending=" + this.pending + ", ready=" + this.ready + "}";
    }

    static class Status
    implements Reindexing.Status {
        private final Instant ready;

        Status(Instant ready) {
            this.ready = Objects.requireNonNull(ready);
        }

        public Instant ready() {
            return this.ready;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.ready.equals(status.ready);
        }

        public int hashCode() {
            return Objects.hash(this.ready);
        }

        public String toString() {
            return "ready at " + this.ready;
        }
    }
}

