/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.TenantName;
import com.yahoo.lang.SettableOptional;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.modelfactory.ActivatedModelsBuilder;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.time.Clock;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.KeeperException;

public class RemoteSession
extends Session {
    private static final Logger log = Logger.getLogger(RemoteSession.class.getName());
    private ApplicationSet applicationSet = null;
    private final ActivatedModelsBuilder applicationLoader;
    private final Clock clock;

    public RemoteSession(TenantName tenant, long sessionId, GlobalComponentRegistry componentRegistry, SessionZooKeeperClient zooKeeperClient) {
        super(tenant, sessionId, zooKeeperClient);
        this.applicationLoader = new ActivatedModelsBuilder(tenant, sessionId, zooKeeperClient, componentRegistry);
        this.clock = componentRegistry.getClock();
    }

    void prepare() {
        Curator.CompletionWaiter waiter = this.sessionZooKeeperClient.getPrepareWaiter();
        this.ensureApplicationLoaded();
        this.notifyCompletion(waiter);
    }

    private ApplicationSet loadApplication() {
        ApplicationPackage applicationPackage = this.sessionZooKeeperClient.loadApplicationPackage();
        SettableOptional allocatedHosts = new SettableOptional(applicationPackage.getAllocatedHosts());
        return ApplicationSet.fromList(this.applicationLoader.buildModels(this.getApplicationId(), this.sessionZooKeeperClient.readDockerImageRepository(), this.sessionZooKeeperClient.readVespaVersion(), applicationPackage, (SettableOptional<AllocatedHosts>)allocatedHosts, this.clock.instant()));
    }

    public synchronized ApplicationSet ensureApplicationLoaded() {
        return this.applicationSet == null ? (this.applicationSet = this.loadApplication()) : this.applicationSet;
    }

    public synchronized void deactivate() {
        this.applicationSet = null;
    }

    void confirmUpload() {
        Curator.CompletionWaiter waiter = this.sessionZooKeeperClient.getUploadWaiter();
        log.log(Level.FINE, "Notifying upload waiter for session " + this.getSessionId());
        this.notifyCompletion(waiter);
        log.log(Level.FINE, "Done notifying upload for session " + this.getSessionId());
    }

    void notifyCompletion(Curator.CompletionWaiter completionWaiter) {
        try {
            completionWaiter.notifyCompletion();
        }
        catch (RuntimeException e) {
            Set<Class<KeeperException.NodeExistsException>> acceptedExceptions = Set.of(KeeperException.NoNodeException.class, KeeperException.NodeExistsException.class);
            Class<?> exceptionClass = e.getCause().getClass();
            if (acceptedExceptions.contains(exceptionClass)) {
                log.log(Level.FINE, "Not able to notify completion for session " + this.getSessionId() + " (" + completionWaiter + "), node " + (exceptionClass.equals(KeeperException.NoNodeException.class) ? "has been deleted" : "already exists"));
            }
            throw e;
        }
    }

    public void delete() {
        CuratorTransaction transaction = this.sessionZooKeeperClient.deleteTransaction();
        transaction.commit();
        transaction.close();
    }
}

