/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Deployment
implements com.yahoo.config.provision.Deployment {
    private static final Logger log = Logger.getLogger(Deployment.class.getName());
    private final LocalSession session;
    private final ApplicationRepository applicationRepository;
    private final Supplier<PrepareParams> params;
    private final Optional<Provisioner> provisioner;
    private final Tenant tenant;
    private final DeployLogger deployLogger;
    private final Clock clock;
    private final boolean internalRedeploy;
    private boolean prepared;
    private ConfigChangeActions configChangeActions;

    private Deployment(LocalSession session, ApplicationRepository applicationRepository, Supplier<PrepareParams> params, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger deployLogger, Clock clock, boolean internalRedeploy, boolean prepared) {
        this.session = session;
        this.applicationRepository = applicationRepository;
        this.params = params;
        this.provisioner = provisioner;
        this.tenant = tenant;
        this.deployLogger = deployLogger;
        this.clock = clock;
        this.internalRedeploy = internalRedeploy;
        this.prepared = prepared;
    }

    public static Deployment unprepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, PrepareParams params, DeployLogger logger, Clock clock) {
        return new Deployment(session, applicationRepository, (Supplier<PrepareParams>)((Supplier)() -> params), provisioner, tenant, logger, clock, false, false);
    }

    public static Deployment unprepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger logger, Duration timeout, Clock clock, boolean validate, boolean isBootstrap, boolean internalRestart) {
        Supplier<PrepareParams> params = Deployment.createPrepareParams(clock, timeout, session, isBootstrap, !validate, false, internalRestart);
        return new Deployment(session, applicationRepository, params, provisioner, tenant, logger, clock, true, false);
    }

    public static Deployment prepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> provisioner, Tenant tenant, DeployLogger logger, Duration timeout, Clock clock, boolean isBootstrap, boolean force) {
        Supplier<PrepareParams> params = Deployment.createPrepareParams(clock, timeout, session, isBootstrap, false, force, false);
        return new Deployment(session, applicationRepository, params, provisioner, tenant, logger, clock, false, true);
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        PrepareParams params = (PrepareParams)this.params.get();
        if (params.internalRestart() && this.provisioner.isEmpty()) {
            throw new IllegalArgumentException("Internal restart not supported without Provisioner");
        }
        ApplicationId applicationId = params.getApplicationId();
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(applicationId, "deployment.prepareMillis");){
            Optional<ApplicationSet> activeApplicationSet = this.applicationRepository.getCurrentActiveApplicationSet(this.tenant, applicationId);
            this.configChangeActions = this.tenant.getSessionRepository().prepareLocalSession(this.session, this.deployLogger, params, activeApplicationSet, this.tenant.getPath(), this.clock.instant());
            this.prepared = true;
        }
    }

    public long activate() {
        this.prepare();
        this.validateSessionStatus(this.session);
        PrepareParams params = (PrepareParams)this.params.get();
        ApplicationId applicationId = this.session.getApplicationId();
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(applicationId, "deployment.activateMillis");){
            RestartActions restartActions;
            Curator.CompletionWaiter waiter;
            RemoteSession previousActiveSession;
            TimeoutBudget timeoutBudget = params.getTimeoutBudget();
            if (!timeoutBudget.hasTimeLeft()) {
                throw new RuntimeException("Timeout exceeded when trying to activate '" + applicationId + "'");
            }
            try (Lock lock = this.tenant.getApplicationRepo().lock(applicationId);){
                previousActiveSession = this.applicationRepository.getActiveSession(applicationId);
                waiter = this.applicationRepository.activate(this.session, previousActiveSession, applicationId, params.force());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalServerException("Error when activating '" + applicationId + "'", e);
            }
            waiter.awaitCompletion(timeoutBudget.timeLeft());
            log.log(Level.INFO, this.session.logPre() + "Session " + this.session.getSessionId() + " activated successfully using " + this.provisioner.map(provisioner -> provisioner.getClass().getSimpleName()).orElse("no host provisioner") + ". Config generation " + this.session.getMetaData().getGeneration() + (String)(previousActiveSession != null ? ". Based on session " + previousActiveSession.getSessionId() : "") + ". File references: " + this.applicationRepository.getFileReferences(applicationId));
            if (params.internalRestart() && !(restartActions = this.configChangeActions.getRestartActions().useForInternalRestart(this.internalRedeploy)).isEmpty()) {
                Set hostnames = restartActions.getEntries().stream().flatMap(entry -> entry.getServices().stream()).map(ServiceInfo::getHostName).collect(Collectors.toUnmodifiableSet());
                this.provisioner.get().restart(applicationId, HostFilter.from(hostnames, Set.of(), Set.of(), Set.of()));
                this.deployLogger.log(Level.INFO, String.format("Scheduled service restart of %d nodes: %s", hostnames.size(), hostnames.stream().sorted().collect(Collectors.joining(", "))));
                this.configChangeActions = new ConfigChangeActions(new RestartActions(), this.configChangeActions.getRefeedActions());
            }
            long l = this.session.getMetaData().getGeneration();
            return l;
        }
    }

    public void restart(HostFilter filter) {
        this.provisioner.get().restart(this.session.getApplicationId(), filter);
    }

    public LocalSession session() {
        return this.session;
    }

    public ConfigChangeActions configChangeActions() {
        if (this.configChangeActions != null) {
            return this.configChangeActions;
        }
        throw new IllegalArgumentException("No config change actions: " + (this.prepared ? "was already prepared" : "not yet prepared"));
    }

    private void validateSessionStatus(LocalSession localSession) {
        long sessionId = localSession.getSessionId();
        if (Session.Status.NEW.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is not prepared");
        }
        if (Session.Status.ACTIVATE.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is already active");
        }
    }

    private static Supplier<PrepareParams> createPrepareParams(Clock clock, Duration timeout, LocalSession session, boolean isBootstrap, boolean ignoreValidationErrors, boolean force, boolean internalRestart) {
        return Suppliers.memoize(() -> {
            TimeoutBudget timeoutBudget = new TimeoutBudget(clock, timeout);
            PrepareParams.Builder params = new PrepareParams.Builder().applicationId(session.getApplicationId()).vespaVersion(session.getVespaVersion().toString()).timeoutBudget(timeoutBudget).ignoreValidationErrors(ignoreValidationErrors).isBootstrap(isBootstrap).force(force).internalRestart(internalRestart);
            session.getDockerImageRepository().ifPresent(params::dockerImageRepository);
            session.getAthenzDomain().ifPresent(params::athenzDomain);
            return params.build();
        });
    }
}

