/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.configchange;

import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.vespa.config.server.configchange.RestartActionsFormatter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class RestartActions {
    private final Map<String, Entry> actions = new TreeMap<String, Entry>();

    private Entry addEntry(ServiceInfo service) {
        String clusterName = service.getProperty("clustername").orElse("");
        String clusterType = service.getProperty("clustertype").orElse("");
        String entryId = clusterType + "." + clusterName + "." + service.getServiceType();
        Entry entry = this.actions.get(entryId);
        if (entry == null) {
            entry = new Entry(clusterName, clusterType, service.getServiceType());
            this.actions.put(entryId, entry);
        }
        return entry;
    }

    public RestartActions() {
    }

    public RestartActions(List<ConfigChangeAction> actions) {
        for (ConfigChangeAction action : actions) {
            if (!action.getType().equals((Object)ConfigChangeAction.Type.RESTART)) continue;
            for (ServiceInfo service : action.getServices()) {
                this.addEntry(service).addService(service).addMessage(action.getMessage());
            }
        }
    }

    public List<Entry> getEntries() {
        return new ArrayList<Entry>(this.actions.values());
    }

    public String format() {
        return new RestartActionsFormatter(this).format();
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public static class Entry {
        private final String clusterName;
        private final String clusterType;
        private final String serviceType;
        private final Set<ServiceInfo> services = new LinkedHashSet<ServiceInfo>();
        private final Set<String> messages = new TreeSet<String>();

        private Entry addService(ServiceInfo service) {
            this.services.add(service);
            return this;
        }

        private Entry addMessage(String message) {
            this.messages.add(message);
            return this;
        }

        private Entry(String clusterName, String clusterType, String serviceType) {
            this.clusterName = clusterName;
            this.clusterType = clusterType;
            this.serviceType = serviceType;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public String getClusterType() {
            return this.clusterType;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public Set<ServiceInfo> getServices() {
            return this.services;
        }

        public Set<String> getMessages() {
            return this.messages;
        }
    }
}

