/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.google.common.collect.ImmutableSet;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.ServerCache;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.PermanentApplicationPackage;
import com.yahoo.vespa.config.server.deploy.ModelContextImpl;
import com.yahoo.vespa.config.server.modelfactory.ModelsBuilder;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.ApplicationRolesStore;
import com.yahoo.vespa.config.server.tenant.ContainerEndpointsCache;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateMetadataStore;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateRetriever;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivatedModelsBuilder
extends ModelsBuilder<Application> {
    private static final Logger log = Logger.getLogger(ActivatedModelsBuilder.class.getName());
    private final TenantName tenant;
    private final long appGeneration;
    private final SessionZooKeeperClient zkClient;
    private final PermanentApplicationPackage permanentApplicationPackage;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final Metrics metrics;
    private final Curator curator;
    private final FlagSource flagSource;
    private final SecretStore secretStore;

    public ActivatedModelsBuilder(TenantName tenant, long appGeneration, SessionZooKeeperClient zkClient, GlobalComponentRegistry globalComponentRegistry) {
        super(globalComponentRegistry.getModelFactoryRegistry(), globalComponentRegistry.getConfigserverConfig(), globalComponentRegistry.getZone(), HostProvisionerProvider.from(globalComponentRegistry.getHostProvisioner()));
        this.tenant = tenant;
        this.appGeneration = appGeneration;
        this.zkClient = zkClient;
        this.permanentApplicationPackage = globalComponentRegistry.getPermanentApplicationPackage();
        this.configDefinitionRepo = globalComponentRegistry.getStaticConfigDefinitionRepo();
        this.metrics = globalComponentRegistry.getMetrics();
        this.curator = globalComponentRegistry.getCurator();
        this.flagSource = globalComponentRegistry.getFlagSource();
        this.secretStore = globalComponentRegistry.getSecretStore();
    }

    @Override
    protected Application buildModelVersion(ModelFactory modelFactory, ApplicationPackage applicationPackage, ApplicationId applicationId, Optional<DockerImage> wantedDockerImageRepository, Version wantedNodeVespaVersion, Optional<AllocatedHosts> ignored) {
        log.log(Level.FINE, String.format("Loading model version %s for session %s application %s", modelFactory.version(), this.appGeneration, applicationId));
        ModelContext.Properties modelContextProperties = this.createModelContextProperties(applicationId);
        Provisioned provisioned = new Provisioned();
        ModelContextImpl modelContext = new ModelContextImpl(applicationPackage, Optional.empty(), this.permanentApplicationPackage.applicationPackage(), new SilentDeployLogger(), this.configDefinitionRepo, (FileRegistry)ActivatedModelsBuilder.getForVersionOrLatest(applicationPackage.getFileRegistries(), modelFactory.version()).orElse(new MockFileRegistry()), this.createStaticProvisioner(applicationPackage.getAllocatedHosts(), modelContextProperties.applicationId(), provisioned), provisioned, modelContextProperties, Optional.empty(), wantedDockerImageRepository, modelFactory.version(), wantedNodeVespaVersion);
        MetricUpdater applicationMetricUpdater = this.metrics.getOrCreateMetricUpdater(Metrics.createDimensions(applicationId));
        ServerCache serverCache = new ServerCache(this.configDefinitionRepo, this.zkClient.getUserConfigDefinitions());
        return new Application(modelFactory.createModel((ModelContext)modelContext), serverCache, this.appGeneration, applicationPackage.getMetaData().isInternalRedeploy(), modelFactory.version(), applicationMetricUpdater, applicationId);
    }

    private static <T> Optional<T> getForVersionOrLatest(Map<Version, T> map, Version version) {
        if (map.isEmpty()) {
            return Optional.empty();
        }
        T value = map.get(version);
        if (value == null) {
            value = map.get(map.keySet().stream().max((a, b) -> a.compareTo(b)).get());
        }
        return Optional.of(value);
    }

    private ModelContext.Properties createModelContextProperties(ApplicationId applicationId) {
        return new ModelContextImpl.Properties(applicationId, this.configserverConfig.multitenant(), ConfigServerSpec.fromConfig(this.configserverConfig), HostName.from((String)this.configserverConfig.loadBalancerAddress()), this.configserverConfig.ztsUrl() != null ? URI.create(this.configserverConfig.ztsUrl()) : null, this.configserverConfig.athenzDnsSuffix(), this.configserverConfig.hostedVespa(), this.zone(), (Set<ContainerEndpoint>)ImmutableSet.copyOf(new ContainerEndpointsCache(TenantRepository.getTenantPath(this.tenant), this.curator).read(applicationId)), false, false, this.flagSource, new EndpointCertificateMetadataStore(this.curator, TenantRepository.getTenantPath(this.tenant)).readEndpointCertificateMetadata(applicationId).flatMap(new EndpointCertificateRetriever(this.secretStore)::readEndpointCertificateSecrets), this.zkClient.readAthenzDomain(), new ApplicationRolesStore(this.curator, TenantRepository.getTenantPath(this.tenant)).readApplicationRoles(applicationId), this.zkClient.readQuota());
    }
}

