/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FlagSource;
import java.io.File;
import java.time.Duration;

public class FileDistributionMaintainer
extends ConfigServerMaintainer {
    private final ApplicationRepository applicationRepository;
    private final File fileReferencesDir;
    private final Duration maxUnusedFileReferenceAge;

    FileDistributionMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, interval, interval);
        this.applicationRepository = applicationRepository;
        this.maxUnusedFileReferenceAge = Duration.ofHours(applicationRepository.configserverConfig().keepUnusedFileReferencesHours());
        this.fileReferencesDir = new File(Defaults.getDefaults().underVespaHome(applicationRepository.configserverConfig().fileReferencesDir()));
    }

    protected boolean maintain() {
        this.applicationRepository.deleteUnusedFiledistributionReferences(this.fileReferencesDir, this.maxUnusedFileReferenceAge);
        return true;
    }
}

