/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.curator.Curator;

public class LocalSession
extends Session {
    protected final ApplicationPackage applicationPackage;
    private final TenantApplications applicationRepo;

    public LocalSession(TenantName tenant, long sessionId, ApplicationPackage applicationPackage, SessionZooKeeperClient sessionZooKeeperClient, TenantApplications applicationRepo) {
        super(tenant, sessionId, sessionZooKeeperClient);
        this.applicationPackage = applicationPackage;
        this.applicationRepo = applicationRepo;
    }

    public ApplicationFile getApplicationFile(Path relativePath, Mode mode) {
        if (mode.equals((Object)Mode.WRITE)) {
            this.markSessionEdited();
        }
        return this.applicationPackage.getFile(relativePath);
    }

    void setPrepared() {
        this.setStatus(Session.Status.PREPARE);
    }

    private Transaction createSetStatusTransaction(Session.Status status) {
        return this.sessionZooKeeperClient.createWriteStatusTransaction(status);
    }

    private void setStatus(Session.Status newStatus) {
        this.sessionZooKeeperClient.writeStatus(newStatus);
    }

    public Curator.CompletionWaiter createActiveWaiter() {
        return this.sessionZooKeeperClient.createActiveWaiter();
    }

    public Transaction createActivateTransaction() {
        Transaction transaction = this.createSetStatusTransaction(Session.Status.ACTIVATE);
        transaction.add(this.applicationRepo.createPutTransaction(this.sessionZooKeeperClient.readApplicationId(), this.getSessionId()).operations());
        return transaction;
    }

    private void markSessionEdited() {
        this.setStatus(Session.Status.NEW);
    }

    public long getActiveSessionAtCreate() {
        return this.applicationPackage.getMetaData().getPreviousActiveGeneration();
    }

    public ApplicationMetaData getMetaData() {
        return this.applicationPackage.getMetaData();
    }

    public ApplicationPackage getApplicationPackage() {
        return this.applicationPackage;
    }

    public static enum Mode {
        READ,
        WRITE;

    }
}

