/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import java.io.File;
import java.time.Duration;
import java.util.logging.Logger;

public class ApplicationPackageMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ApplicationPackageMaintainer.class.getName());
    private final ApplicationRepository applicationRepository;
    private final ConnectionPool connectionPool;
    private final File downloadDirectory;
    private final BooleanFlag distributeApplicationPackage;

    ApplicationPackageMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, interval, interval);
        this.applicationRepository = applicationRepository;
        ConfigserverConfig configserverConfig = applicationRepository.configserverConfig();
        this.connectionPool = FileDistributionUtil.createConnectionPool(configserverConfig);
        this.distributeApplicationPackage = (BooleanFlag)Flags.CONFIGSERVER_DISTRIBUTE_APPLICATION_PACKAGE.bindTo(flagSource);
        this.downloadDirectory = new File(Defaults.getDefaults().underVespaHome(configserverConfig.fileReferencesDir()));
    }

    protected boolean maintain() {
        boolean success = true;
        if (!this.distributeApplicationPackage.value()) {
            return success;
        }
        try (FileDownloader fileDownloader = new FileDownloader(this.connectionPool, this.downloadDirectory);){
            for (ApplicationId applicationId : this.applicationRepository.listApplications()) {
                log.fine(() -> "Verifying application package for " + applicationId);
                RemoteSession session = this.applicationRepository.getActiveSession(applicationId);
                if (session == null) continue;
                FileReference applicationPackage = session.getApplicationPackageReference();
                long sessionId = session.getSessionId();
                log.fine(() -> "Verifying application package file reference " + applicationPackage + " for session " + sessionId);
                if (applicationPackage == null) continue;
                if (!FileDistributionUtil.fileReferenceExistsOnDisk(this.downloadDirectory, applicationPackage)) {
                    log.fine(() -> "Downloading missing application package for application " + applicationId + " - session " + sessionId);
                    if (fileDownloader.getFile(applicationPackage).isEmpty()) {
                        success = false;
                        log.warning("Failed to download application package for application " + applicationId + " - session " + sessionId);
                        continue;
                    }
                }
                this.createLocalSessionIfMissing(applicationId, sessionId);
            }
        }
        return success;
    }

    public void close() {
        this.connectionPool.close();
        super.close();
    }

    private void createLocalSessionIfMissing(ApplicationId applicationId, long sessionId) {
        Tenant tenant = this.applicationRepository.tenantRepository().getTenant(applicationId.tenant());
        SessionRepository sessionRepository = tenant.getSessionRepository();
        if (sessionRepository.getLocalSession(sessionId) == null) {
            sessionRepository.createLocalSessionUsingDistributedApplicationPackage(sessionId);
        }
    }
}

