/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Duration;

public class SessionsMaintainer
extends ConfigServerMaintainer {
    private final boolean hostedVespa;

    SessionsMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, Duration.ZERO, interval);
        this.hostedVespa = applicationRepository.configserverConfig().hostedVespa();
    }

    protected boolean maintain() {
        int deleted;
        this.applicationRepository.deleteExpiredLocalSessions();
        if (this.hostedVespa) {
            Duration expiryTime = Duration.ofHours(12L);
            deleted = this.applicationRepository.deleteExpiredRemoteSessions(expiryTime);
            this.log.log(LogLevel.FINE, () -> "Deleted " + deleted + " expired remote sessions older than " + expiryTime);
        }
        Duration lockExpiryTime = Duration.ofHours(12L);
        deleted = this.applicationRepository.deleteExpiredLocks(lockExpiryTime);
        this.log.log(LogLevel.FINE, () -> "Deleted " + deleted + " locks older than " + lockExpiryTime);
        return true;
    }
}

