/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.concurrent.maintenance.JobControl;
import com.yahoo.concurrent.maintenance.JobControlState;
import com.yahoo.concurrent.maintenance.JobMetrics;
import com.yahoo.concurrent.maintenance.Maintainer;
import com.yahoo.jdisc.Metric;
import com.yahoo.path.Path;
import com.yahoo.transaction.Mutex;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.ListFlag;
import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Set;

public abstract class ConfigServerMaintainer
extends Maintainer {
    protected final ApplicationRepository applicationRepository;

    ConfigServerMaintainer(ApplicationRepository applicationRepository, Curator curator, FlagSource flagSource, Duration initialDelay, Duration interval) {
        super(null, interval, initialDelay, new JobControl((JobControlState)new JobControlFlags(curator, flagSource)), ConfigServerMaintainer.jobMetrics(applicationRepository.clock(), applicationRepository.metric()));
        this.applicationRepository = applicationRepository;
    }

    private static JobMetrics jobMetrics(Clock clock, Metric metric) {
        return new JobMetrics(clock, (job, instant) -> {
            Duration sinceSuccess = Duration.between(instant, clock.instant());
            metric.set("maintenance.secondsSinceSuccess", (Number)sinceSuccess.getSeconds(), metric.createContext(Map.of("job", job)));
        });
    }

    private static class JobControlFlags
    implements JobControlState {
        private static final Path root = Path.fromString((String)"/configserver/v1/");
        private static final Path lockRoot = root.append("locks");
        private final Curator curator;
        private final ListFlag<String> inactiveJobsFlag;

        public JobControlFlags(Curator curator, FlagSource flagSource) {
            this.curator = curator;
            this.inactiveJobsFlag = (ListFlag)Flags.INACTIVE_MAINTENANCE_JOBS.bindTo(flagSource);
        }

        public Set<String> readInactiveJobs() {
            return Set.copyOf(this.inactiveJobsFlag.value());
        }

        public Mutex lockMaintenanceJob(String job) {
            return this.curator.lock(lockRoot.append(job), Duration.ofSeconds(1L));
        }
    }
}

