/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.FlagSource;
import java.io.File;
import java.time.Duration;

public class FileDistributionMaintainer
extends ConfigServerMaintainer {
    private final ApplicationRepository applicationRepository;
    private final File fileReferencesDir;
    private final ConfigserverConfig configserverConfig;

    FileDistributionMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, ConfigserverConfig configserverConfig, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, interval, interval);
        this.applicationRepository = applicationRepository;
        this.configserverConfig = configserverConfig;
        this.fileReferencesDir = new File(Defaults.getDefaults().underVespaHome(configserverConfig.fileReferencesDir()));
    }

    protected void maintain() {
        this.applicationRepository.deleteUnusedFiledistributionReferences(this.fileReferencesDir, Duration.ofHours(this.configserverConfig.keepUnusedFileReferencesHours()));
    }
}

