/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.curator.Curator;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.recipes.cache.ChildData;

public class LocalSessionStateWatcher {
    private static final Logger log = Logger.getLogger(LocalSessionStateWatcher.class.getName());
    private final Curator.FileCache fileCache;
    private final LocalSession session;
    private final SessionRepository sessionRepository;
    private final Executor zkWatcherExecutor;

    LocalSessionStateWatcher(Curator.FileCache fileCache, LocalSession session, SessionRepository sessionRepository, Executor zkWatcherExecutor) {
        this.fileCache = fileCache;
        this.session = session;
        this.sessionRepository = sessionRepository;
        this.zkWatcherExecutor = zkWatcherExecutor;
        this.fileCache.start();
        this.fileCache.addListener(this::nodeChanged);
    }

    private void sessionChanged(Session.Status status) {
        long sessionId = this.session.getSessionId();
        log.log(status == Session.Status.DELETE ? Level.INFO : Level.FINE, this.session.logPre() + "Session change: Local session " + sessionId + " changed status to " + status);
        if (status.equals((Object)Session.Status.DELETE) && this.sessionRepository.getLocalSession(sessionId) != null) {
            log.log(Level.FINE, this.session.logPre() + "Deleting session " + sessionId);
            this.sessionRepository.deleteLocalSession(this.session);
        }
    }

    public long getSessionId() {
        return this.session.getSessionId();
    }

    public void close() {
        try {
            this.fileCache.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception when closing watcher", e);
        }
    }

    public void nodeChanged() {
        this.zkWatcherExecutor.execute(() -> {
            try {
                ChildData node = this.fileCache.getCurrentData();
                if (node != null) {
                    this.sessionChanged(Session.Status.parse(Utf8.toString((byte[])node.getData())));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, this.session.logPre() + "Error handling session changed for session " + this.getSessionId(), e);
            }
        });
    }
}

