/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.application.provider.DeployData;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.config.provision.TenantName;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionPreparer;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.config.server.zookeeper.SessionCounter;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.Flags;
import java.io.File;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionFactory {
    private static final Logger log = Logger.getLogger(SessionFactory.class.getName());
    private static final long nonExistingActiveSession = 0L;
    private final SessionPreparer sessionPreparer;
    private final Curator curator;
    private final ConfigCurator configCurator;
    private final TenantApplications applicationRepo;
    private final Path sessionsPath;
    private final GlobalComponentRegistry componentRegistry;
    private final HostValidator<ApplicationId> hostRegistry;
    private final TenantName tenant;
    private final String serverId;
    private final Optional<NodeFlavors> nodeFlavors;
    private final Clock clock;
    private final BooleanFlag distributeApplicationPackage;

    public SessionFactory(GlobalComponentRegistry globalComponentRegistry, TenantApplications applicationRepo, HostValidator<ApplicationId> hostRegistry, TenantName tenant) {
        this.hostRegistry = hostRegistry;
        this.tenant = tenant;
        this.sessionPreparer = globalComponentRegistry.getSessionPreparer();
        this.curator = globalComponentRegistry.getCurator();
        this.configCurator = globalComponentRegistry.getConfigCurator();
        this.sessionsPath = TenantRepository.getSessionsPath(tenant);
        this.applicationRepo = applicationRepo;
        this.componentRegistry = globalComponentRegistry;
        this.serverId = globalComponentRegistry.getConfigserverConfig().serverId();
        this.nodeFlavors = globalComponentRegistry.getZone().nodeFlavors();
        this.clock = globalComponentRegistry.getClock();
        this.distributeApplicationPackage = (BooleanFlag)Flags.CONFIGSERVER_DISTRIBUTE_APPLICATION_PACKAGE.bindTo(globalComponentRegistry.getFlagSource());
    }

    public LocalSession createSession(File applicationDirectory, ApplicationId applicationId, TimeoutBudget timeoutBudget, Optional<Long> activeSessionId) {
        return this.create(applicationDirectory, applicationId, activeSessionId.orElse(0L), false, timeoutBudget);
    }

    public RemoteSession createRemoteSession(long sessionId) {
        Path sessionPath = this.sessionsPath.append(String.valueOf(sessionId));
        SessionZooKeeperClient sessionZKClient = this.createSessionZooKeeperClient(sessionPath);
        return new RemoteSession(this.tenant, sessionId, this.componentRegistry, sessionZKClient);
    }

    private void ensureSessionPathDoesNotExist(long sessionId) {
        Path sessionPath = this.getSessionPath(sessionId);
        if (this.configCurator.exists(sessionPath.getAbsolute())) {
            throw new IllegalArgumentException("Path " + sessionPath.getAbsolute() + " already exists in ZooKeeper");
        }
    }

    private ApplicationPackage createApplication(File userDir, File configApplicationDir, ApplicationId applicationId, long sessionId, long currentlyActiveSessionId, boolean internalRedeploy) {
        long deployTimestamp = System.currentTimeMillis();
        String user = System.getenv("USER");
        if (user == null) {
            user = "unknown";
        }
        DeployData deployData = new DeployData(user, userDir.getAbsolutePath(), applicationId, Long.valueOf(deployTimestamp), internalRedeploy, Long.valueOf(sessionId), currentlyActiveSessionId);
        return FilesApplicationPackage.fromFileWithDeployData((File)configApplicationDir, (DeployData)deployData);
    }

    private LocalSession createSessionFromApplication(ApplicationPackage applicationPackage, long sessionId, SessionZooKeeperClient sessionZKClient, TimeoutBudget timeoutBudget, Clock clock) {
        log.log(Level.FINE, TenantRepository.logPre(this.tenant) + "Creating session " + sessionId + " in ZooKeeper");
        sessionZKClient.createNewSession(clock.instant());
        Curator.CompletionWaiter waiter = sessionZKClient.getUploadWaiter();
        LocalSession session = new LocalSession(this.tenant, sessionId, this.sessionPreparer, applicationPackage, sessionZKClient, this.getSessionAppDir(sessionId), this.applicationRepo, this.hostRegistry);
        waiter.awaitCompletion(timeoutBudget.timeLeft());
        return session;
    }

    public LocalSession createSessionFromExisting(Session existingSession, DeployLogger logger, boolean internalRedeploy, TimeoutBudget timeoutBudget) {
        File existingApp = this.getSessionAppDir(existingSession.getSessionId());
        ApplicationId existingApplicationId = existingSession.getApplicationId();
        long activeSessionId = this.getActiveSessionId(existingApplicationId);
        logger.log(Level.FINE, "Create new session for application id '" + existingApplicationId + "' from existing active session " + activeSessionId);
        LocalSession session = this.create(existingApp, existingApplicationId, activeSessionId, internalRedeploy, timeoutBudget);
        session.setApplicationId(existingApplicationId);
        if (this.distributeApplicationPackage.value() && existingSession.getApplicationPackageReference() != null) {
            session.setApplicationPackageReference(existingSession.getApplicationPackageReference());
        }
        session.setVespaVersion(existingSession.getVespaVersion());
        session.setDockerImageRepository(existingSession.getDockerImageRepository());
        session.setAthenzDomain(existingSession.getAthenzDomain());
        return session;
    }

    private LocalSession create(File applicationFile, ApplicationId applicationId, long currentlyActiveSessionId, boolean internalRedeploy, TimeoutBudget timeoutBudget) {
        long sessionId = this.getNextSessionId();
        try {
            this.ensureSessionPathDoesNotExist(sessionId);
            SessionZooKeeperClient sessionZooKeeperClient = this.createSessionZooKeeperClient(this.getSessionPath(sessionId));
            File userApplicationDir = this.getSessionAppDir(sessionId);
            IOUtils.copyDirectory((File)applicationFile, (File)userApplicationDir);
            ApplicationPackage applicationPackage = this.createApplication(applicationFile, userApplicationDir, applicationId, sessionId, currentlyActiveSessionId, internalRedeploy);
            applicationPackage.writeMetaData();
            return this.createSessionFromApplication(applicationPackage, sessionId, sessionZooKeeperClient, timeoutBudget, this.clock);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating session " + sessionId, e);
        }
    }

    LocalSession createSessionFromId(long sessionId) {
        File sessionDir = this.getAndValidateExistingSessionAppDir(sessionId);
        FilesApplicationPackage applicationPackage = FilesApplicationPackage.fromFile((File)sessionDir);
        Path sessionIdPath = this.sessionsPath.append(String.valueOf(sessionId));
        SessionZooKeeperClient sessionZKClient = this.createSessionZooKeeperClient(sessionIdPath);
        return new LocalSession(this.tenant, sessionId, this.sessionPreparer, (ApplicationPackage)applicationPackage, sessionZKClient, this.getSessionAppDir(sessionId), this.applicationRepo, this.hostRegistry);
    }

    private long getActiveSessionId(ApplicationId applicationId) {
        List<ApplicationId> applicationIds = this.applicationRepo.activeApplications();
        if (applicationIds.contains(applicationId)) {
            return this.applicationRepo.requireActiveSessionOf(applicationId);
        }
        return 0L;
    }

    private long getNextSessionId() {
        return new SessionCounter(this.componentRegistry.getConfigCurator(), this.tenant).nextSessionId();
    }

    private Path getSessionPath(long sessionId) {
        return this.sessionsPath.append(String.valueOf(sessionId));
    }

    private SessionZooKeeperClient createSessionZooKeeperClient(Path sessionPath) {
        return new SessionZooKeeperClient(this.curator, this.configCurator, sessionPath, this.serverId, this.nodeFlavors);
    }

    private File getAndValidateExistingSessionAppDir(long sessionId) {
        File appDir = this.getSessionAppDir(sessionId);
        if (!appDir.exists() || !appDir.isDirectory()) {
            throw new IllegalArgumentException("Unable to find correct application directory for session " + sessionId);
        }
        return appDir;
    }

    private File getSessionAppDir(long sessionId) {
        return new TenantFileSystemDirs(this.componentRegistry.getConfigServerDB(), this.tenant).getUserApplicationDir(sessionId);
    }
}

