/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.UserConfigDefinitionRepo;
import com.yahoo.vespa.config.server.deploy.ZooKeeperClient;
import com.yahoo.vespa.config.server.deploy.ZooKeeperDeployer;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.config.server.zookeeper.ZKApplicationPackage;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionZooKeeperClient {
    private static final Logger log = Logger.getLogger(SessionZooKeeperClient.class.getName());
    static final String APPLICATION_ID_PATH = "applicationId";
    private static final String VERSION_PATH = "version";
    private static final String CREATE_TIME_PATH = "createTime";
    private static final String DOCKER_IMAGE_REPOSITORY_PATH = "dockerImageRepository";
    private static final String ATHENZ_DOMAIN = "athenzDomain";
    private final Curator curator;
    private final ConfigCurator configCurator;
    private final Path sessionPath;
    private final Path sessionStatusPath;
    private final String serverId;
    private final Optional<NodeFlavors> nodeFlavors;
    private static final String PREPARE_BARRIER = "prepareBarrier";
    private static final String ACTIVE_BARRIER = "activeBarrier";
    private static final String UPLOAD_BARRIER = "uploadBarrier";

    public SessionZooKeeperClient(Curator curator, Path sessionPath) {
        this(curator, ConfigCurator.create(curator), sessionPath, "", Optional.empty());
    }

    public SessionZooKeeperClient(Curator curator, ConfigCurator configCurator, Path sessionPath, String serverId, Optional<NodeFlavors> nodeFlavors) {
        this.curator = curator;
        this.configCurator = configCurator;
        this.sessionPath = sessionPath;
        this.serverId = serverId;
        this.nodeFlavors = nodeFlavors;
        this.sessionStatusPath = sessionPath.append("/sessionState");
    }

    public void writeStatus(Session.Status sessionStatus) {
        try {
            this.createWriteStatusTransaction(sessionStatus).commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write session status", e);
        }
    }

    public Session.Status readStatus() {
        try {
            String data = this.configCurator.getData(this.sessionStatusPath.getAbsolute());
            return Session.Status.parse(data);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Unable to read session status, assuming it was deleted");
            return Session.Status.NONE;
        }
    }

    Curator.CompletionWaiter createPrepareWaiter() {
        return this.createCompletionWaiter(PREPARE_BARRIER);
    }

    Curator.CompletionWaiter createActiveWaiter() {
        return this.createCompletionWaiter(ACTIVE_BARRIER);
    }

    Curator.CompletionWaiter getPrepareWaiter() {
        return this.getCompletionWaiter(this.getWaiterPath(PREPARE_BARRIER));
    }

    Curator.CompletionWaiter getActiveWaiter() {
        return this.getCompletionWaiter(this.getWaiterPath(ACTIVE_BARRIER));
    }

    Curator.CompletionWaiter getUploadWaiter() {
        return this.getCompletionWaiter(this.getWaiterPath(UPLOAD_BARRIER));
    }

    private Path getWaiterPath(String barrierName) {
        return this.sessionPath.append(barrierName);
    }

    private int getNumberOfMembers() {
        return this.curator.zooKeeperEnsembleCount() / 2 + 1;
    }

    private Curator.CompletionWaiter createCompletionWaiter(String waiterNode) {
        return this.curator.createCompletionWaiter(this.sessionPath, waiterNode, this.getNumberOfMembers(), this.serverId);
    }

    private Curator.CompletionWaiter getCompletionWaiter(Path path) {
        return this.curator.getCompletionWaiter(path, this.getNumberOfMembers(), this.serverId);
    }

    public void delete(NestedTransaction transaction) {
        try {
            log.log(Level.FINE, "Deleting " + this.sessionPath.getAbsolute());
            CuratorTransaction curatorTransaction = new CuratorTransaction(this.curator);
            CuratorOperations.deleteAll((String)this.sessionPath.getAbsolute(), (Curator)this.curator).forEach(arg_0 -> ((CuratorTransaction)curatorTransaction).add(arg_0));
            transaction.add((Transaction)curatorTransaction, new Class[0]);
            transaction.commit();
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, "Error deleting session (" + this.sessionPath.getAbsolute() + ") from zookeeper", e);
        }
    }

    public CuratorTransaction deleteTransaction() {
        return CuratorTransaction.from((List)CuratorOperations.deleteAll((String)this.sessionPath.getAbsolute(), (Curator)this.curator), (Curator)this.curator);
    }

    public ApplicationPackage loadApplicationPackage() {
        return new ZKApplicationPackage(this.configCurator, this.sessionPath, this.nodeFlavors);
    }

    public ConfigDefinitionRepo getUserConfigDefinitions() {
        return new UserConfigDefinitionRepo(this.configCurator, this.sessionPath.append("/userdefconfigs").getAbsolute());
    }

    private String applicationIdPath() {
        return this.sessionPath.append(APPLICATION_ID_PATH).getAbsolute();
    }

    public void writeApplicationId(ApplicationId id) {
        this.configCurator.putData(this.applicationIdPath(), id.serializedForm());
    }

    public ApplicationId readApplicationId() {
        if (!this.configCurator.exists(this.applicationIdPath())) {
            return ApplicationId.defaultId();
        }
        return ApplicationId.fromSerializedForm((String)this.configCurator.getData(this.applicationIdPath()));
    }

    private String versionPath() {
        return this.sessionPath.append(VERSION_PATH).getAbsolute();
    }

    private String dockerImageRepositoryPath() {
        return this.sessionPath.append(DOCKER_IMAGE_REPOSITORY_PATH).getAbsolute();
    }

    private String athenzDomainPath() {
        return this.sessionPath.append(ATHENZ_DOMAIN).getAbsolute();
    }

    public void writeVespaVersion(Version version) {
        this.configCurator.putData(this.versionPath(), version.toString());
    }

    public Version readVespaVersion() {
        if (!this.configCurator.exists(this.versionPath())) {
            return Vtag.currentVersion;
        }
        return new Version(this.configCurator.getData(this.versionPath()));
    }

    public Optional<DockerImage> readDockerImageRepository() {
        if (!this.configCurator.exists(this.dockerImageRepositoryPath())) {
            return Optional.empty();
        }
        String dockerImageRepository = this.configCurator.getData(this.dockerImageRepositoryPath());
        return dockerImageRepository.isEmpty() ? Optional.empty() : Optional.of(DockerImage.fromString((String)dockerImageRepository));
    }

    public void writeDockerImageRepository(Optional<DockerImage> dockerImageRepository) {
        dockerImageRepository.ifPresent(repo -> this.configCurator.putData(this.dockerImageRepositoryPath(), repo.repository()));
    }

    public Instant readCreateTime() {
        String path = this.getCreateTimePath();
        if (!this.configCurator.exists(path)) {
            return Instant.EPOCH;
        }
        return Instant.ofEpochSecond(Long.parseLong(this.configCurator.getData(path)));
    }

    private String getCreateTimePath() {
        return this.sessionPath.append(CREATE_TIME_PATH).getAbsolute();
    }

    AllocatedHosts getAllocatedHosts() {
        return (AllocatedHosts)this.loadApplicationPackage().getAllocatedHosts().orElseThrow(() -> new IllegalStateException("Allocated hosts does not exists"));
    }

    public ZooKeeperDeployer createDeployer(DeployLogger logger) {
        ZooKeeperClient zkClient = new ZooKeeperClient(this.configCurator, logger, true, this.sessionPath);
        return new ZooKeeperDeployer(zkClient);
    }

    public Transaction createWriteStatusTransaction(Session.Status status) {
        String path = this.sessionStatusPath.getAbsolute();
        CuratorTransaction transaction = new CuratorTransaction(this.curator);
        if (this.configCurator.exists(path)) {
            transaction.add((Transaction.Operation)CuratorOperations.setData((String)this.sessionStatusPath.getAbsolute(), (byte[])Utf8.toBytes((String)status.name())));
        } else {
            transaction.add((Transaction.Operation)CuratorOperations.create((String)this.sessionStatusPath.getAbsolute(), (byte[])Utf8.toBytes((String)status.name())));
        }
        return transaction;
    }

    public void writeAthenzDomain(Optional<AthenzDomain> athenzDomain) {
        athenzDomain.ifPresent(domain -> this.configCurator.putData(this.athenzDomainPath(), domain.value()));
    }

    public Optional<AthenzDomain> readAthenzDomain() {
        if (!this.configCurator.exists(this.athenzDomainPath())) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.configCurator.getData(this.athenzDomainPath())).filter(domain -> !domain.isBlank()).map(AthenzDomain::from);
    }

    public void createNewSession(Instant createTime) {
        CuratorTransaction transaction = new CuratorTransaction(this.curator);
        transaction.add((Transaction.Operation)CuratorOperations.create((String)this.sessionPath.getAbsolute()));
        transaction.add((Transaction.Operation)CuratorOperations.create((String)this.sessionPath.append(UPLOAD_BARRIER).getAbsolute()));
        transaction.add(this.createWriteStatusTransaction(Session.Status.NEW).operations());
        transaction.add((Transaction.Operation)CuratorOperations.create((String)this.getCreateTimePath(), (byte[])Utf8.toBytes((String)String.valueOf(createTime.getEpochSecond()))));
        transaction.commit();
    }
}

