/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.component.Version;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.Optional;

public abstract class Session {
    private final long sessionId;
    protected final TenantName tenant;
    protected final SessionZooKeeperClient zooKeeperClient;

    protected Session(TenantName tenant, long sessionId, SessionZooKeeperClient zooKeeperClient) {
        this.tenant = tenant;
        this.sessionId = sessionId;
        this.zooKeeperClient = zooKeeperClient;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    public Status getStatus() {
        return this.zooKeeperClient.readStatus();
    }

    public String toString() {
        return "Session,id=" + this.sessionId;
    }

    public TenantName getTenant() {
        return this.tenant;
    }

    public String logPre() {
        return TenantRepository.logPre(this.getTenant());
    }

    public long getCreateTime() {
        return this.zooKeeperClient.readCreateTime();
    }

    public void setApplicationId(ApplicationId applicationId) {
        this.zooKeeperClient.writeApplicationId(applicationId);
    }

    public void setVespaVersion(Version version) {
        this.zooKeeperClient.writeVespaVersion(version);
    }

    public void setDockerImageRepository(Optional<DockerImage> dockerImageRepository) {
        this.zooKeeperClient.writeDockerImageRepository(dockerImageRepository);
    }

    public void setAthenzDomain(Optional<AthenzDomain> athenzDomain) {
        this.zooKeeperClient.writeAthenzDomain(athenzDomain);
    }

    public ApplicationId getApplicationId() {
        return this.zooKeeperClient.readApplicationId();
    }

    public Optional<DockerImage> getDockerImageRepository() {
        return this.zooKeeperClient.readDockerImageRepository();
    }

    public Version getVespaVersion() {
        return this.zooKeeperClient.readVespaVersion();
    }

    public Optional<AthenzDomain> getAthenzDomain() {
        return this.zooKeeperClient.readAthenzDomain();
    }

    public AllocatedHosts getAllocatedHosts() {
        return this.zooKeeperClient.getAllocatedHosts();
    }

    public static enum Status {
        NEW,
        PREPARE,
        ACTIVATE,
        DEACTIVATE,
        DELETE,
        NONE;


        public static Status parse(String data) {
            for (Status status : Status.values()) {
                if (!status.name().equals(data)) continue;
                return status;
            }
            return NEW;
        }
    }
}

