/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.ModelCreateResult;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.ValidationParameters;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.PermanentApplicationPackage;
import com.yahoo.vespa.config.server.deploy.ModelContextImpl;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionProvider;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import com.yahoo.vespa.config.server.modelfactory.ModelsBuilder;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.provision.StaticProvisioner;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.SessionContext;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PreparedModelsBuilder
extends ModelsBuilder<PreparedModelResult> {
    private static final Logger log = Logger.getLogger(PreparedModelsBuilder.class.getName());
    private final PermanentApplicationPackage permanentApplicationPackage;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final SessionContext context;
    private final DeployLogger logger;
    private final PrepareParams params;
    private final FileDistributionProvider fileDistributionProvider;
    private final Optional<ApplicationSet> currentActiveApplicationSet;
    private final ModelContext.Properties properties;

    public PreparedModelsBuilder(ModelFactoryRegistry modelFactoryRegistry, PermanentApplicationPackage permanentApplicationPackage, ConfigDefinitionRepo configDefinitionRepo, FileDistributionProvider fileDistributionProvider, HostProvisionerProvider hostProvisionerProvider, SessionContext context, DeployLogger logger, PrepareParams params, Optional<ApplicationSet> currentActiveApplicationSet, ModelContext.Properties properties, ConfigserverConfig configserverConfig) {
        super(modelFactoryRegistry, configserverConfig, properties.zone(), hostProvisionerProvider);
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileDistributionProvider = fileDistributionProvider;
        this.context = context;
        this.logger = logger;
        this.params = params;
        this.currentActiveApplicationSet = currentActiveApplicationSet;
        this.properties = properties;
    }

    @Override
    protected PreparedModelResult buildModelVersion(ModelFactory modelFactory, ApplicationPackage applicationPackage, ApplicationId applicationId, Optional<DockerImage> wantedDockerImageRepository, Version wantedNodeVespaVersion, Optional<AllocatedHosts> allocatedHosts, Instant now) {
        Version modelVersion = modelFactory.version();
        log.log(Level.FINE, "Building model " + modelVersion + " for " + applicationId);
        Provisioned provisioned = new Provisioned();
        ModelContextImpl modelContext = new ModelContextImpl(applicationPackage, this.modelOf(modelVersion), this.permanentApplicationPackage.applicationPackage(), this.logger, this.configDefinitionRepo, this.fileDistributionProvider.getFileRegistry(), this.createHostProvisioner(allocatedHosts, provisioned), provisioned, this.properties, this.getAppDir(applicationPackage), wantedDockerImageRepository, modelVersion, wantedNodeVespaVersion);
        log.log(Level.FINE, "Create and validate model " + modelVersion + " for " + applicationId);
        ValidationParameters validationParameters = new ValidationParameters(this.params.ignoreValidationErrors() ? ValidationParameters.IgnoreValidationErrors.TRUE : ValidationParameters.IgnoreValidationErrors.FALSE);
        ModelCreateResult result = modelFactory.createAndValidateModel((ModelContext)modelContext, validationParameters);
        this.validateModelHosts(this.context.getHostValidator(), applicationId, result.getModel());
        log.log(Level.FINE, "Done building model " + modelVersion + " for " + applicationId);
        return new PreparedModelResult(modelVersion, result.getModel(), this.fileDistributionProvider, result.getConfigChangeActions());
    }

    private Optional<Model> modelOf(Version version) {
        if (this.currentActiveApplicationSet.isEmpty()) {
            return Optional.empty();
        }
        return this.currentActiveApplicationSet.get().get(version).map(Application::getModel);
    }

    private Optional<HostProvisioner> createHostProvisioner(Optional<AllocatedHosts> allocatedHosts, Provisioned provisioned) {
        Optional<HostProvisioner> nodeRepositoryProvisioner = this.createNodeRepositoryProvisioner(this.properties.applicationId(), provisioned);
        if (allocatedHosts.isEmpty()) {
            return nodeRepositoryProvisioner;
        }
        Optional<HostProvisioner> staticProvisioner = this.createStaticProvisioner(allocatedHosts, this.properties.applicationId(), provisioned);
        if (staticProvisioner.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new StaticProvisioner(allocatedHosts.get(), nodeRepositoryProvisioner.get()));
    }

    private Optional<File> getAppDir(ApplicationPackage applicationPackage) {
        try {
            return applicationPackage instanceof FilesApplicationPackage ? Optional.of(((FilesApplicationPackage)applicationPackage).getAppDir()) : Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not find app dir", e);
        }
    }

    private void validateModelHosts(HostValidator<ApplicationId> hostValidator, ApplicationId applicationId, Model model) {
        hostValidator.verifyHosts(applicationId, model.getHosts().stream().map(HostInfo::getHostname).collect(Collectors.toList()));
    }

    public static class PreparedModelResult
    implements ModelResult {
        public final Version version;
        public final Model model;
        public final FileDistributionProvider fileDistributionProvider;
        public final List<ConfigChangeAction> actions;

        public PreparedModelResult(Version version, Model model, FileDistributionProvider fileDistributionProvider, List<ConfigChangeAction> actions) {
            this.version = version;
            this.model = model;
            this.fileDistributionProvider = fileDistributionProvider;
            this.actions = actions;
        }

        @Override
        public Model getModel() {
            return this.model;
        }
    }
}

