/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import ai.vespa.util.http.VespaHttpClientBuilder;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.MetricsAggregator;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class ClusterMetricsRetriever {
    private static final Logger log = Logger.getLogger(ClusterMetricsRetriever.class.getName());
    private static final String VESPA_CONTAINER = "vespa.container";
    private static final String VESPA_QRSERVER = "vespa.qrserver";
    private static final String VESPA_DISTRIBUTOR = "vespa.distributor";
    private static final List<String> WANTED_METRIC_SERVICES = List.of("vespa.container", "vespa.qrserver", "vespa.distributor");
    private static final CloseableHttpClient httpClient = VespaHttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build()).build();

    public Map<ClusterInfo, MetricsAggregator> requestMetricsGroupedByCluster(Collection<URI> hosts) {
        ConcurrentHashMap<ClusterInfo, MetricsAggregator> clusterMetricsMap = new ConcurrentHashMap<ClusterInfo, MetricsAggregator>();
        long startTime = System.currentTimeMillis();
        Runnable retrieveMetricsJob = () -> hosts.parallelStream().forEach(host -> ClusterMetricsRetriever.getHostMetrics(host, clusterMetricsMap));
        ForkJoinPool threadPool = new ForkJoinPool(5);
        threadPool.submit(retrieveMetricsJob);
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        log.log((Level)LogLevel.DEBUG, () -> String.format("Metric retrieval for %d nodes took %d milliseconds", hosts.size(), System.currentTimeMillis() - startTime));
        return clusterMetricsMap;
    }

    private static void getHostMetrics(URI hostURI, Map<ClusterInfo, MetricsAggregator> clusterMetricsMap) {
        Slime responseBody = ClusterMetricsRetriever.doMetricsRequest(hostURI);
        Cursor parseError = responseBody.get().field("error_message");
        if (parseError.valid()) {
            log.info("Failed to retrieve metrics from " + hostURI + ": " + parseError.asString());
        }
        Cursor services = responseBody.get().field("services");
        services.traverse((i, servicesInspector) -> ClusterMetricsRetriever.parseService(servicesInspector, clusterMetricsMap));
    }

    private static Slime doMetricsRequest(URI hostURI) {
        Slime slime;
        block8: {
            HttpGet get = new HttpGet(hostURI);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            try {
                InputStream is = response.getEntity().getContent();
                Slime slime2 = SlimeUtils.jsonToSlime((byte[])is.readAllBytes());
                is.close();
                slime = slime2;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.info("Was unable to fetch metrics from " + hostURI + " : " + Exceptions.toMessageString((Throwable)e));
                    return new Slime();
                }
            }
            response.close();
        }
        return slime;
    }

    private static void parseService(Inspector service, Map<ClusterInfo, MetricsAggregator> clusterMetricsMap) {
        String serviceName = service.field("name").asString();
        service.field("metrics").traverse((i, metric) -> ClusterMetricsRetriever.addMetricsToAggeregator(serviceName, metric, clusterMetricsMap));
    }

    private static void addMetricsToAggeregator(String serviceName, Inspector metric, Map<ClusterInfo, MetricsAggregator> clusterMetricsMap) {
        if (!WANTED_METRIC_SERVICES.contains(serviceName)) {
            return;
        }
        Inspector values = metric.field("values");
        ClusterInfo clusterInfo = ClusterMetricsRetriever.getClusterInfoFromDimensions(metric.field("dimensions"));
        MetricsAggregator metricsAggregator = clusterMetricsMap.computeIfAbsent(clusterInfo, c -> new MetricsAggregator());
        switch (serviceName) {
            case "vespa.container": {
                metricsAggregator.addContainerLatency(values.field("query_latency.sum").asDouble(), values.field("query_latency.count").asDouble());
                metricsAggregator.addFeedLatency(values.field("feed.latency.sum").asDouble(), values.field("feed.latency.count").asDouble());
                break;
            }
            case "vespa.qrserver": {
                metricsAggregator.addQrLatency(values.field("query_latency.sum").asDouble(), values.field("query_latency.count").asDouble());
                break;
            }
            case "vespa.distributor": {
                metricsAggregator.addDocumentCount(values.field("vds.distributor.docsstored.average").asDouble());
            }
        }
    }

    private static ClusterInfo getClusterInfoFromDimensions(Inspector dimensions) {
        return new ClusterInfo(dimensions.field("clusterid").asString(), dimensions.field("clustertype").asString());
    }
}

