/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.util.http.VespaHttpClientBuilder;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.http.HttpFetcher;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.RequestTimeoutException;
import com.yahoo.vespa.config.server.http.StaticResponse;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class SimpleHttpFetcher
implements HttpFetcher {
    private static final Logger logger = Logger.getLogger(SimpleHttpFetcher.class.getName());
    private final CloseableHttpClient client = VespaHttpClientBuilder.create().build();

    @Override
    public HttpResponse get(HttpFetcher.Params params, URL url) {
        StaticResponse staticResponse;
        block10: {
            HttpGet request = new HttpGet(url.toURI());
            request.addHeader("Connection", "Close");
            request.setConfig(RequestConfig.custom().setConnectTimeout(params.readTimeoutMs).setSocketTimeout(params.readTimeoutMs).build());
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
            try {
                HttpEntity entity = response.getEntity();
                staticResponse = new StaticResponse(response.getStatusLine().getStatusCode(), entity.getContentType().getValue(), EntityUtils.toString((HttpEntity)entity));
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                String message;
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SocketTimeoutException | ConnectTimeoutException e) {
                    message = "Timed out after " + params.readTimeoutMs + " ms reading response from " + url;
                    logger.log(LogLevel.WARNING, message, e);
                    throw new RequestTimeoutException(message);
                }
                catch (IOException e) {
                    message = "Failed to get response from " + url;
                    logger.log(LogLevel.WARNING, message, e);
                    throw new InternalServerException(message);
                }
                catch (URISyntaxException e) {
                    message = "Invalid URL: " + e.getMessage();
                    logger.log(LogLevel.WARNING, message, e);
                    throw new InternalServerException(message, e);
                }
            }
            response.close();
        }
        return staticResponse;
    }
}

