/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.model;

import com.yahoo.cloud.config.LbServicesConfig;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.SuperModel;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.server.model.LbServicesProducer;
import com.yahoo.vespa.flags.FlagSource;
import java.util.Collections;
import java.util.Map;

public class SuperModelConfigProvider
implements LbServicesConfig.Producer {
    private final SuperModel superModel;
    private final LbServicesProducer lbProd;

    public SuperModelConfigProvider(SuperModel superModel, Zone zone, FlagSource flagSource) {
        this.superModel = superModel;
        this.lbProd = new LbServicesProducer(Collections.unmodifiableMap(superModel.getModelsPerTenant()), zone, flagSource);
    }

    public SuperModel getSuperModel() {
        return this.superModel;
    }

    public ConfigPayload getConfig(ConfigKey<?> configKey) {
        if (configKey.equals((Object)new ConfigKey(LbServicesConfig.class, configKey.getConfigId()))) {
            LbServicesConfig.Builder builder = new LbServicesConfig.Builder();
            this.getConfig(builder);
            return ConfigPayload.fromInstance((ConfigInstance)new LbServicesConfig(builder));
        }
        throw new ConfigurationRuntimeException(configKey + " is not valid when asking for config from SuperModel");
    }

    public Map<ApplicationId, ApplicationInfo> applicationModels() {
        return this.superModel.getModels();
    }

    public void getConfig(LbServicesConfig.Builder builder) {
        this.lbProd.getConfig(builder);
    }

    public <CONFIGTYPE extends ConfigInstance> CONFIGTYPE getConfig(Class<CONFIGTYPE> configClass, ApplicationId applicationId, String configId) {
        Map models = this.superModel.getModels();
        if (!models.containsKey(applicationId)) {
            throw new IllegalArgumentException("Application " + applicationId + " not found");
        }
        ApplicationInfo application = (ApplicationInfo)models.get(applicationId);
        ConfigKey key = new ConfigKey(configClass, configId);
        ConfigPayload payload = application.getModel().getConfig(key, null);
        return (CONFIGTYPE)payload.toInstance(configClass, configId);
    }
}

