/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.config.model.api.TlsSecrets;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.util.Optional;

public class TlsSecretsKeys {
    private final Path path;
    private final SecretStore secretStore;
    private final Curator curator;

    public TlsSecretsKeys(Curator curator, Path tenantPath, SecretStore secretStore) {
        this.curator = curator;
        this.path = tenantPath.append("tlsSecretsKeys/");
        this.secretStore = secretStore;
    }

    public Optional<TlsSecrets> readTlsSecretsKeyFromZookeeper(ApplicationId application) {
        try {
            Optional data = this.curator.getData(this.tlsSecretsKeyOf(application));
            if (data.isEmpty() || ((byte[])data.get()).length == 0) {
                return Optional.empty();
            }
            String tlsSecretsKey = (String)new ObjectMapper().readValue((byte[])data.get(), (TypeReference)new TypeReference<String>(){});
            return this.readFromSecretStore(Optional.ofNullable(tlsSecretsKey));
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading TLS secret key of " + application, e);
        }
    }

    public void writeTlsSecretsKeyToZooKeeper(ApplicationId application, String tlsSecretsKey) {
        if (tlsSecretsKey == null) {
            return;
        }
        try {
            byte[] data = new ObjectMapper().writeValueAsBytes((Object)tlsSecretsKey);
            this.curator.set(this.tlsSecretsKeyOf(application), data);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write TLS secret key of " + application, e);
        }
    }

    public Optional<TlsSecrets> getTlsSecrets(Optional<String> secretKeyname, ApplicationId applicationId) {
        if (secretKeyname == null || secretKeyname.isEmpty()) {
            return this.readTlsSecretsKeyFromZookeeper(applicationId);
        }
        return this.readFromSecretStore(secretKeyname);
    }

    private Optional<TlsSecrets> readFromSecretStore(Optional<String> secretKeyname) {
        if (secretKeyname.isEmpty()) {
            return Optional.empty();
        }
        try {
            String cert = this.secretStore.getSecret(secretKeyname.get() + "-cert");
            String key = this.secretStore.getSecret(secretKeyname.get() + "-key");
            return Optional.of(new TlsSecrets(cert, key));
        }
        catch (RuntimeException e) {
            return Optional.of(TlsSecrets.MISSING);
        }
    }

    public CuratorTransaction delete(ApplicationId application) {
        if (!this.curator.exists(this.tlsSecretsKeyOf(application))) {
            return CuratorTransaction.empty((Curator)this.curator);
        }
        return CuratorTransaction.from((CuratorOperation)CuratorOperations.delete((String)this.tlsSecretsKeyOf(application).getAbsolute()), (Curator)this.curator);
    }

    private Path tlsSecretsKeyOf(ApplicationId application) {
        return this.path.append(application.serializedForm());
    }
}

