/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.model.api.PortInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.container.jdisc.jrt.JrtFactory;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.http.JSONResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;

public class FileDistributionStatus
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(FileDistributionStatus.class.getName());
    private final ExecutorService rpcExecutor = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory("filedistribution status"));
    private final Supervisor supervisor;

    @Inject
    public FileDistributionStatus(JrtFactory jrtFactory) {
        this.supervisor = jrtFactory.createSupervisor();
    }

    public StatusAllHosts status(Application application, Duration timeout) {
        ArrayList<HostStatus> hostStatuses = new ArrayList<HostStatus>();
        ArrayList results = new ArrayList();
        application.getModel().getHosts().forEach(host -> host.getServices().stream().filter(service -> "configproxy".equals(service.getServiceType())).forEach(service -> results.add(this.rpcExecutor.submit(() -> this.getHostStatus(service.getHostName(), FileDistributionStatus.getRpcPort(service), timeout)))));
        results.forEach(future -> {
            try {
                hostStatuses.add((HostStatus)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                log.log(LogLevel.WARNING, "Failed getting file distribution status", e);
            }
        });
        return this.createStatusForAllHosts(hostStatuses);
    }

    HostStatus getHostStatus(String hostname, int port, Duration timeout) {
        Target target = this.supervisor.connect(new Spec(hostname, port));
        Request request = new Request("filedistribution.getActiveFileReferencesStatus");
        target.invokeSync(request, (double)(timeout.toMillis() / 1000L));
        HostStatus hostStatus = this.createHostStatusFromResponse(hostname, request);
        target.close();
        return hostStatus;
    }

    private HostStatus createHostStatusFromResponse(String hostname, Request request) {
        if (request.isError()) {
            return new HostStatus(hostname, Status.UNKNOWN, Collections.emptyMap(), "error: " + request.errorMessage() + "(" + request.errorCode() + ")");
        }
        HashMap<String, Double> fileReferenceStatuses = new HashMap<String, Double>();
        String[] fileReferences = request.returnValues().get(0).asStringArray();
        double[] downloadStatus = request.returnValues().get(1).asDoubleArray();
        boolean allDownloaded = true;
        for (int i = 0; i < fileReferences.length; ++i) {
            fileReferenceStatuses.put(fileReferences[i], downloadStatus[i]);
            if (!(downloadStatus[i] < 1.0)) continue;
            allDownloaded = false;
        }
        return new HostStatus(hostname, allDownloaded ? Status.FINISHED : Status.IN_PROGRESS, fileReferenceStatuses, "");
    }

    private StatusAllHosts createStatusForAllHosts(List<HostStatus> hostStatuses) {
        int countUnknown = 0;
        int countInProgress = 0;
        int countFinished = 0;
        for (HostStatus hostStatus : hostStatuses) {
            switch (hostStatus.status) {
                case IN_PROGRESS: {
                    ++countInProgress;
                    break;
                }
                case FINISHED: {
                    ++countFinished;
                    break;
                }
                case UNKNOWN: {
                    ++countUnknown;
                    break;
                }
            }
        }
        if (countInProgress == 0 && countUnknown == 0) {
            return new StatusAllHosts(Status.FINISHED, hostStatuses);
        }
        if (countInProgress == 0 && countFinished == 0) {
            return new StatusAllHosts(Status.UNKNOWN, hostStatuses);
        }
        return new StatusAllHosts(Status.IN_PROGRESS, hostStatuses);
    }

    private static Integer getRpcPort(ServiceInfo service) {
        return service.getPorts().stream().filter(port -> port.getTags().contains("rpc")).map(PortInfo::getPort).findFirst().orElseThrow(() -> new RuntimeException("Could not find rpc port for " + service.getServiceType() + " on " + service.getHostName()));
    }

    static class HostStatus {
        private final String hostname;
        private final Status status;
        private final Map<String, Double> fileReferenceStatuses;
        private final Optional<String> errorMessage;

        HostStatus(String hostname, Status status, Map<String, Double> fileReferenceStatuses) {
            this.hostname = hostname;
            this.status = status;
            this.fileReferenceStatuses = fileReferenceStatuses;
            this.errorMessage = Optional.empty();
        }

        HostStatus(String hostname, Status status, Map<String, Double> fileReferenceStatuses, String errorMessage) {
            this.hostname = hostname;
            this.status = status;
            this.fileReferenceStatuses = fileReferenceStatuses;
            this.errorMessage = Optional.of(errorMessage);
        }

        public String hostname() {
            return this.hostname;
        }

        public String toString() {
            return this.hostname + ": " + (Object)((Object)this.status) + ", " + this.fileReferenceStatuses + " " + this.errorMessage.orElse("");
        }
    }

    private static class StatusAllHosts
    extends JSONResponse {
        private StatusAllHosts(Status status, List<HostStatus> hostStatuses) {
            super(200);
            Cursor hostsArray = this.object.setArray("hosts");
            for (HostStatus hostStatus : hostStatuses) {
                Cursor host = hostsArray.addObject();
                host.setString("hostname", hostStatus.hostname);
                host.setString("status", hostStatus.status.name());
                hostStatus.errorMessage.ifPresent(message -> host.setString("message", message));
                Cursor fileReferences = host.setArray("fileReferences");
                hostStatus.fileReferenceStatuses.forEach((key, value) -> fileReferences.addObject().setDouble(key, value.doubleValue()));
            }
            this.object.setString("status", status.name());
        }
    }

    static enum Status {
        UNKNOWN,
        FINISHED,
        IN_PROGRESS;

    }
}

