/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.flags;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.json.DimensionHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;

public class DefinedFlags
extends HttpResponse {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Comparator<FlagDefinition> sortByFlagId = (left, right) -> left.getUnboundFlag().id().compareTo(right.getUnboundFlag().id());
    private final List<FlagDefinition> flags;

    public DefinedFlags(List<FlagDefinition> flags) {
        super(200);
        this.flags = flags;
    }

    public void render(OutputStream outputStream) throws IOException {
        ObjectNode rootNode = mapper.createObjectNode();
        this.flags.stream().sorted(sortByFlagId).forEach(flagDefinition -> {
            ObjectNode definitionNode = rootNode.putObject(flagDefinition.getUnboundFlag().id().toString());
            definitionNode.put("description", flagDefinition.getDescription());
            definitionNode.put("modification-effect", flagDefinition.getModificationEffect());
            ArrayNode dimensionsNode = definitionNode.putArray("dimensions");
            flagDefinition.getDimensions().forEach(dimension -> dimensionsNode.add(DimensionHelper.toWire((FetchVector.Dimension)dimension)));
        });
        mapper.writeValue(outputStream, (Object)rootNode);
    }

    public String getContentType() {
        return "application/json";
    }
}

