/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.flags;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.json.FlagData;
import com.yahoo.yolean.Exceptions;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;

public class FlagDataListResponse
extends HttpResponse {
    private static ObjectMapper mapper = new ObjectMapper();
    private final String flagsV1Uri;
    private final Map<FlagId, FlagData> flags;
    private final boolean recursive;

    public FlagDataListResponse(String flagsV1Uri, Map<FlagId, FlagData> flags, boolean recursive) {
        super(200);
        this.flagsV1Uri = flagsV1Uri;
        this.flags = flags;
        this.recursive = recursive;
    }

    public void render(OutputStream outputStream) {
        ObjectNode rootNode = mapper.createObjectNode();
        ArrayNode flagsArray = rootNode.putArray("flags");
        new TreeMap<FlagId, FlagData>(this.flags).forEach((flagId, flagData) -> {
            if (this.recursive) {
                flagsArray.add(flagData.toJsonNode());
            } else {
                ObjectNode object = flagsArray.addObject();
                object.put("id", flagId.toString());
                object.put("url", this.flagsV1Uri + "/data/" + flagId.toString());
            }
        });
        Exceptions.uncheck(() -> mapper.writeValue(outputStream, (Object)rootNode));
    }

    public String getContentType() {
        return "application/json";
    }
}

