/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.container.jdisc.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class LogRetriever {
    private static final Logger log = Logger.getLogger(LogRetriever.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse getLogs(String logServerHostname) {
        HttpGet get = new HttpGet(logServerHostname);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            HttpResponse httpResponse = new HttpResponse(response.getStatusLine().getStatusCode(), (org.apache.http.HttpResponse)response, responseBody){
                final /* synthetic */ org.apache.http.HttpResponse val$response;
                final /* synthetic */ String val$responseBody;
                {
                    this.val$response = httpResponse;
                    this.val$responseBody = string;
                    super(x0);
                }

                public void render(OutputStream outputStream) throws IOException {
                    if (this.val$response.getEntity() != null) {
                        outputStream.write(this.val$responseBody.getBytes());
                    }
                }
            };
            return httpResponse;
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to retrieve logs from log server", e);
            return new HttpResponse(404){

                public void render(OutputStream outputStream) throws IOException {
                    outputStream.write(e.toString().getBytes());
                }
            };
        }
    }
}

