/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationLockException;
import com.yahoo.config.provision.OutOfCapacityException;
import com.yahoo.config.provision.Version;
import com.yahoo.config.provision.Zone;
import com.yahoo.lang.SettableOptional;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.UnknownVespaVersionException;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import com.yahoo.vespa.config.server.provision.StaticProvisioner;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class ModelsBuilder<MODELRESULT extends ModelResult> {
    private static final Logger log = Logger.getLogger(ModelsBuilder.class.getName());
    private final ModelFactoryRegistry modelFactoryRegistry;
    protected final ConfigserverConfig configserverConfig;
    private final boolean hosted;
    private final Zone zone;

    protected ModelsBuilder(ModelFactoryRegistry modelFactoryRegistry, ConfigserverConfig configserverConfig, Zone zone) {
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.configserverConfig = configserverConfig;
        this.hosted = configserverConfig.hostedVespa();
        this.zone = zone;
    }

    protected Zone zone() {
        return this.zone;
    }

    public List<MODELRESULT> buildModels(ApplicationId applicationId, com.yahoo.component.Version wantedNodeVespaVersion, ApplicationPackage applicationPackage, SettableOptional<AllocatedHosts> allocatedHosts, Instant now) {
        Set<Version> versions = this.modelFactoryRegistry.allVersions();
        Optional requestedMajorVersion = applicationPackage.getMajorVersion();
        if (requestedMajorVersion.isPresent()) {
            versions = this.filterByMajorVersion((Integer)requestedMajorVersion.get(), versions);
        }
        List majorVersions = versions.stream().map(Version::getMajor).distinct().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        ArrayList<MODELRESULT> allApplicationModels = new ArrayList<MODELRESULT>();
        for (int i = 0; i < majorVersions.size(); ++i) {
            try {
                allApplicationModels.addAll(this.buildModelVersions(this.filterByMajorVersion((Integer)majorVersions.get(i), versions), applicationId, wantedNodeVespaVersion, applicationPackage, allocatedHosts, now));
                if (allApplicationModels.size() <= 0 || !((ModelResult)allApplicationModels.get(0)).getModel().skipOldConfigModels(now)) continue;
                break;
            }
            catch (ApplicationLockException | OutOfCapacityException e) {
                throw e;
            }
            catch (RuntimeException e) {
                boolean isOldestMajor;
                boolean bl = isOldestMajor = i == majorVersions.size() - 1;
                if (isOldestMajor) {
                    if (e instanceof NullPointerException || e instanceof NoSuchElementException | e instanceof UncheckedTimeoutException) {
                        log.log(LogLevel.WARNING, "Unexpected error when building model ", e);
                        throw new InternalServerException(applicationId + ": Error loading model", e);
                    }
                    log.log(LogLevel.WARNING, "Input error when building model ", e);
                    throw new IllegalArgumentException(applicationId + ": Error loading model", e);
                }
                log.log(Level.INFO, applicationId + ": Skipping major version " + majorVersions.get(i), e);
            }
        }
        return allApplicationModels;
    }

    private List<MODELRESULT> buildModelVersions(Set<Version> versions, ApplicationId applicationId, com.yahoo.component.Version wantedNodeVespaVersion, ApplicationPackage applicationPackage, SettableOptional<AllocatedHosts> allocatedHosts, Instant now) {
        Version latest = this.findLatest(versions);
        MODELRESULT latestModelVersion = this.buildModelVersion(this.modelFactoryRegistry.getFactory(latest), applicationPackage, applicationId, wantedNodeVespaVersion, allocatedHosts.asOptional(), now);
        allocatedHosts.set((Object)latestModelVersion.getModel().allocatedHosts());
        ArrayList<MODELRESULT> allApplicationVersions = new ArrayList<MODELRESULT>(Collections.singletonList(latestModelVersion));
        if (latestModelVersion.getModel().skipOldConfigModels(now)) {
            return allApplicationVersions;
        }
        versions = this.versionsToBuild(versions, wantedNodeVespaVersion, (AllocatedHosts)allocatedHosts.get());
        for (Version version : versions) {
            if (version.equals((Object)latest)) continue;
            MODELRESULT modelVersion = this.buildModelVersion(this.modelFactoryRegistry.getFactory(version), applicationPackage, applicationId, wantedNodeVespaVersion, allocatedHosts.asOptional(), now);
            allocatedHosts.set((Object)modelVersion.getModel().allocatedHosts());
            allApplicationVersions.add(modelVersion);
        }
        return allApplicationVersions;
    }

    private Set<Version> versionsToBuild(Set<Version> versions, com.yahoo.component.Version wantedVersion, AllocatedHosts allocatedHosts) {
        if (this.configserverConfig.buildMinimalSetOfConfigModels()) {
            versions = this.keepThoseUsedOn(allocatedHosts, versions);
        }
        Version wanted = Version.fromIntValues((int)wantedVersion.getMajor(), (int)wantedVersion.getMinor(), (int)wantedVersion.getMicro());
        if (this.hosted && (versions.isEmpty() || wantedVersion.getMajor() == this.findLatest(versions).getMajor())) {
            versions.add(wanted);
        }
        return versions;
    }

    private Set<Version> filterByMajorVersion(int majorVersion, Set<Version> versions) {
        Set<Version> filteredVersions = versions.stream().filter(v -> v.getMajor() == majorVersion).collect(Collectors.toSet());
        if (filteredVersions.isEmpty()) {
            throw new UnknownVespaVersionException("No Vespa versions matching major version " + majorVersion + " are present");
        }
        return filteredVersions;
    }

    private Version findLatest(Set<Version> versionSet) {
        ArrayList<Version> versionList = new ArrayList<Version>(versionSet);
        Collections.sort(versionList);
        return (Version)versionList.get(versionList.size() - 1);
    }

    private Set<Version> keepThoseUsedOn(AllocatedHosts hosts, Set<Version> versions) {
        return versions.stream().filter(version -> this.mayBeUsedOn(hosts, (Version)version)).collect(Collectors.toSet());
    }

    private boolean mayBeUsedOn(AllocatedHosts hosts, Version version) {
        com.yahoo.component.Version v = new com.yahoo.component.Version(version.toString());
        return hosts.getHosts().stream().anyMatch(host -> !host.version().isPresent() || ((com.yahoo.component.Version)host.version().get()).equals((Object)v));
    }

    protected abstract MODELRESULT buildModelVersion(ModelFactory var1, ApplicationPackage var2, ApplicationId var3, com.yahoo.component.Version var4, Optional<AllocatedHosts> var5, Instant var6);

    protected Optional<HostProvisioner> createStaticProvisioner(Optional<AllocatedHosts> allocatedHosts) {
        if (this.hosted && allocatedHosts.isPresent()) {
            return Optional.of(new StaticProvisioner(allocatedHosts.get()));
        }
        return Optional.empty();
    }
}

