/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.FileDistributionMaintainer;
import com.yahoo.vespa.config.server.maintenance.TenantsMaintainer;
import com.yahoo.vespa.config.server.maintenance.ZooKeeperDataMaintainer;
import com.yahoo.vespa.config.server.session.FileDistributionFactory;
import com.yahoo.vespa.curator.Curator;
import java.time.Duration;

public class ConfigServerMaintenance
extends AbstractComponent {
    private final TenantsMaintainer tenantsMaintainer;
    private final ZooKeeperDataMaintainer zooKeeperDataMaintainer;
    private final FileDistributionMaintainer fileDistributionMaintainer;

    public ConfigServerMaintenance(ConfigserverConfig configserverConfig, ApplicationRepository applicationRepository, Curator curator, FileDistributionFactory fileDistributionFactory) {
        DefaultTimes defaults = new DefaultTimes(configserverConfig);
        this.tenantsMaintainer = new TenantsMaintainer(applicationRepository, curator, defaults.defaultInterval);
        this.zooKeeperDataMaintainer = new ZooKeeperDataMaintainer(applicationRepository, curator, defaults.defaultInterval);
        this.fileDistributionMaintainer = new FileDistributionMaintainer(applicationRepository, curator, defaults.defaultInterval, configserverConfig);
    }

    public void deconstruct() {
        this.tenantsMaintainer.deconstruct();
        this.zooKeeperDataMaintainer.deconstruct();
        this.fileDistributionMaintainer.deconstruct();
    }

    private static class DefaultTimes {
        private final Duration defaultInterval;

        DefaultTimes(ConfigserverConfig configserverConfig) {
            this.defaultInterval = Duration.ofMinutes(configserverConfig.maintainerIntervalMinutes());
        }
    }
}

