/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.http.ContentHandler;
import com.yahoo.vespa.config.server.http.ContentRequest;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.JSONResponse;
import com.yahoo.vespa.config.server.http.NotFoundException;
import com.yahoo.vespa.config.server.http.v2.ApplicationContentRequest;
import com.yahoo.vespa.config.server.http.v2.HttpConfigRequests;
import com.yahoo.vespa.config.server.tenant.Tenant;
import java.time.Duration;

public class ApplicationHandler
extends HttpHandler {
    private final Zone zone;
    private final ApplicationRepository applicationRepository;

    @Inject
    public ApplicationHandler(LoggingRequestHandler.Context ctx, Zone zone, ApplicationRepository applicationRepository) {
        super(ctx);
        this.zone = zone;
        this.applicationRepository = applicationRepository;
    }

    @Override
    public HttpResponse handleDELETE(HttpRequest request) {
        ApplicationId applicationId = ApplicationHandler.getApplicationIdFromRequest(request);
        boolean removed = this.applicationRepository.remove(applicationId);
        if (!removed) {
            return HttpErrorResponse.notFoundError("Unable to delete " + applicationId + ": Not found");
        }
        return new DeleteApplicationResponse(200, applicationId);
    }

    @Override
    public HttpResponse handleGET(HttpRequest request) {
        ApplicationId applicationId = ApplicationHandler.getApplicationIdFromRequest(request);
        Tenant tenant = this.verifyTenantAndApplication(applicationId);
        if (ApplicationHandler.isServiceConvergeRequest(request)) {
            String hostAndPort = ApplicationHandler.getHostNameFromRequest(request);
            return this.applicationRepository.checkServiceForConfigConvergence(applicationId, hostAndPort, request.getUri());
        }
        if (ApplicationHandler.isClusterControllerStatusRequest(request)) {
            String hostName = ApplicationHandler.getHostNameFromRequest(request);
            String pathSuffix = ApplicationHandler.getPathSuffix(request);
            return this.applicationRepository.clusterControllerStatusPage(applicationId, hostName, pathSuffix);
        }
        if (ApplicationHandler.isContentRequest(request)) {
            long sessionId = this.applicationRepository.getSessionIdForApplication(tenant, applicationId);
            String contentPath = ApplicationContentRequest.getContentPath(request);
            ApplicationFile applicationFile = this.applicationRepository.getApplicationFileFromSession(tenant.getName(), sessionId, contentPath, ContentRequest.getApplicationFileMode(request.getMethod()));
            ApplicationContentRequest contentRequest = new ApplicationContentRequest(request, sessionId, applicationId, this.zone, contentPath, applicationFile);
            return new ContentHandler().get(contentRequest);
        }
        if (ApplicationHandler.isServiceConvergeListRequest(request)) {
            return this.applicationRepository.servicesToCheckForConfigConvergence(applicationId, request.getUri());
        }
        if (ApplicationHandler.isFiledistributionStatusRequest(request)) {
            Duration timeout = HttpHandler.getRequestTimeout(request, Duration.ofSeconds(5L));
            return this.applicationRepository.filedistributionStatus(applicationId, timeout);
        }
        return new GetApplicationResponse(200, this.applicationRepository.getApplicationGeneration(applicationId));
    }

    @Override
    public HttpResponse handlePOST(HttpRequest request) {
        ApplicationId applicationId = ApplicationHandler.getApplicationIdFromRequest(request);
        if (request.getUri().getPath().endsWith("restart")) {
            return this.restart(request, applicationId);
        }
        throw new NotFoundException("Illegal POST request '" + request.getUri() + "': Must end with /restart");
    }

    private HttpResponse restart(HttpRequest request, ApplicationId applicationId) {
        if (ApplicationHandler.getBindingMatch(request).groupCount() != 7) {
            throw new NotFoundException("Illegal POST restart request '" + request.getUri() + "': Must have 6 arguments but had " + (ApplicationHandler.getBindingMatch(request).groupCount() - 1));
        }
        this.applicationRepository.restart(applicationId, this.hostFilterFrom(request));
        return new JSONResponse(200);
    }

    private HostFilter hostFilterFrom(HttpRequest request) {
        return HostFilter.from((String)request.getProperty("hostname"), (String)request.getProperty("flavor"), (String)request.getProperty("clusterType"), (String)request.getProperty("clusterId"));
    }

    private Tenant verifyTenantAndApplication(ApplicationId applicationId) {
        try {
            return this.applicationRepository.verifyTenantAndApplication(applicationId);
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(e.getMessage());
        }
    }

    private static BindingMatch<?> getBindingMatch(HttpRequest request) {
        return HttpConfigRequests.getBindingMatch(request, "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/content/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/filedistributionstatus", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/restart", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/serviceconverge", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/serviceconverge/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/clustercontroller/*/status/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*", "http://*/application/v2/tenant/*/application/*");
    }

    private static boolean isServiceConvergeListRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/serviceconverge");
    }

    private static boolean isServiceConvergeRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 8 && request.getUri().getPath().contains("/serviceconverge/");
    }

    private static boolean isClusterControllerStatusRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 9 && request.getUri().getPath().contains("/clustercontroller/");
    }

    private static boolean isContentRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() > 7 && request.getUri().getPath().contains("/content/");
    }

    private static boolean isFiledistributionStatusRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().contains("/filedistributionstatus");
    }

    private static String getHostNameFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(7);
    }

    private static String getPathSuffix(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(8);
    }

    private static ApplicationId getApplicationIdFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        if (bm.groupCount() > 4) {
            return ApplicationHandler.createFromRequestFullAppId(bm);
        }
        return ApplicationHandler.createFromRequestSimpleAppId(bm);
    }

    private static ApplicationId createFromRequestSimpleAppId(BindingMatch<?> bm) {
        TenantName tenant = TenantName.from((String)bm.group(2));
        ApplicationName application = ApplicationName.from((String)bm.group(3));
        return new ApplicationId.Builder().tenant(tenant).applicationName(application).build();
    }

    private static ApplicationId createFromRequestFullAppId(BindingMatch<?> bm) {
        String tenant = bm.group(2);
        String application = bm.group(3);
        String instance = bm.group(6);
        return new ApplicationId.Builder().tenant(tenant).applicationName(application).instanceName(instance).build();
    }

    private static class GetApplicationResponse
    extends JSONResponse {
        GetApplicationResponse(int status, long generation) {
            super(status);
            this.object.setLong("generation", generation);
        }
    }

    private static class DeleteApplicationResponse
    extends JSONResponse {
        DeleteApplicationResponse(int status, ApplicationId applicationId) {
            super(status);
            this.object.setString("message", "Application '" + applicationId + "' deleted");
        }
    }
}

