/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.container.jdisc.state.StateMonitor;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.rpc.RpcServer;
import com.yahoo.vespa.config.server.version.VersionState;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigServerBootstrap
extends AbstractComponent
implements Runnable {
    private static final Logger log = Logger.getLogger(ConfigServerBootstrap.class.getName());
    private static final ExecutorService rpcServerExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory("config server RPC server"));
    private static final String vipStatusClusterIdentifier = "configserver";
    private final ApplicationRepository applicationRepository;
    private final RpcServer server;
    private final Thread serverThread;
    private final VersionState versionState;
    private final StateMonitor stateMonitor;
    private final VipStatus vipStatus;

    @Inject
    public ConfigServerBootstrap(ApplicationRepository applicationRepository, RpcServer server, VersionState versionState, StateMonitor stateMonitor, VipStatus vipStatus) {
        this(applicationRepository, server, versionState, stateMonitor, vipStatus, true);
    }

    ConfigServerBootstrap(ApplicationRepository applicationRepository, RpcServer server, VersionState versionState, StateMonitor stateMonitor, VipStatus vipStatus, boolean startMainThread) {
        this.applicationRepository = applicationRepository;
        this.server = server;
        this.versionState = versionState;
        this.stateMonitor = stateMonitor;
        this.serverThread = new Thread((Runnable)this, "configserver main");
        this.vipStatus = vipStatus;
        this.initializing();
        if (startMainThread) {
            this.start();
        }
    }

    public void deconstruct() {
        log.log(LogLevel.INFO, "Stopping config server");
        this.down();
        this.server.stop();
        rpcServerExecutor.shutdown();
        try {
            this.serverThread.join();
        }
        catch (InterruptedException e) {
            log.log(LogLevel.WARNING, "Error joining server thread on shutdown: " + e.getMessage());
        }
    }

    @Override
    public void run() {
        if (this.versionState.isUpgraded()) {
            log.log(LogLevel.INFO, "Configserver upgrading from " + this.versionState.storedVersion() + " to " + this.versionState.currentVersion() + ". Redeploying all applications");
            try {
                this.applicationRepository.redeployAllApplications();
                this.versionState.saveNewVersion();
                log.log(LogLevel.INFO, "All applications redeployed successfully");
            }
            catch (Exception e) {
                log.log((Level)LogLevel.ERROR, "Redeployment of applications failed", e);
                return;
            }
        }
        this.startRpcServer();
        this.up();
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.log((Level)LogLevel.ERROR, "Got interrupted", e);
                break;
            }
        } while (this.server.isRunning());
        this.down();
        log.log(LogLevel.INFO, "RPC server stopped");
    }

    StateMonitor.Status status() {
        return this.stateMonitor.status();
    }

    private void start() {
        this.serverThread.start();
    }

    private void up() {
        this.stateMonitor.status(StateMonitor.Status.up);
        this.vipStatus.addToRotation((Object)vipStatusClusterIdentifier);
    }

    private void down() {
        this.stateMonitor.status(StateMonitor.Status.down);
        this.vipStatus.removeFromRotation((Object)vipStatusClusterIdentifier);
    }

    private void initializing() {
        this.stateMonitor.status(StateMonitor.Status.initializing);
        this.vipStatus.removeFromRotation((Object)vipStatusClusterIdentifier);
    }

    private void startRpcServer() {
        log.log(LogLevel.INFO, "Starting RPC server");
        rpcServerExecutor.execute(this.server);
        Instant end = Instant.now().plus(Duration.ofSeconds(10L));
        while (!this.server.isRunning() && Instant.now().isBefore(end)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                log.log((Level)LogLevel.ERROR, "Got interrupted", e);
                break;
            }
        }
        if (!this.server.isRunning()) {
            throw new RuntimeException("RPC server not started in 10 seconds");
        }
        log.log(LogLevel.INFO, "RPC server started");
    }
}

