/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.PortInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.http.JSONResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.client.proxy.WebResourceFactory;

public class ApplicationConvergenceChecker
extends AbstractComponent {
    private static final String statePath = "/state/v1/";
    private static final String configSubPath = "config";
    private static final Set<String> serviceTypesToCheck = new HashSet<String>(Arrays.asList("container", "qrserver", "docprocservice", "searchnode", "storagenode", "distributor"));
    private final StateApiFactory stateApiFactory;
    private final Client client = ClientBuilder.newClient();

    @Inject
    public ApplicationConvergenceChecker() {
        this(ApplicationConvergenceChecker::createStateApi);
    }

    public ApplicationConvergenceChecker(StateApiFactory stateApiFactory) {
        this.stateApiFactory = stateApiFactory;
    }

    public ServiceListResponse serviceListToCheckForConfigConvergence(Application application, URI uri) {
        ArrayList<ServiceInfo> servicesToCheck = new ArrayList<ServiceInfo>();
        application.getModel().getHosts().forEach(host -> host.getServices().stream().filter(service -> serviceTypesToCheck.contains(service.getServiceType())).forEach(service -> ApplicationConvergenceChecker.getStatePort(service).ifPresent(port -> servicesToCheck.add((ServiceInfo)service))));
        long currentGeneration = this.getServiceGeneration(servicesToCheck);
        return new ServiceListResponse(200, servicesToCheck, uri, application.getApplicationGeneration(), currentGeneration);
    }

    public ServiceResponse serviceConvergenceCheck(Application application, String hostAndPortToCheck, URI uri) {
        Long wantedGeneration = application.getApplicationGeneration();
        try {
            if (!this.hostInApplication(application, hostAndPortToCheck)) {
                return ServiceResponse.createHostNotFoundInAppResponse(uri, hostAndPortToCheck, wantedGeneration);
            }
            long currentGeneration = this.getServiceGeneration(URI.create("http://" + hostAndPortToCheck));
            boolean converged = currentGeneration >= wantedGeneration;
            return ServiceResponse.createOkResponse(uri, hostAndPortToCheck, wantedGeneration, currentGeneration, converged);
        }
        catch (ProcessingException e) {
            return ServiceResponse.createNotFoundResponse(uri, hostAndPortToCheck, wantedGeneration, e.getMessage());
        }
        catch (Exception e) {
            return ServiceResponse.createErrorResponse(uri, hostAndPortToCheck, wantedGeneration, e.getMessage());
        }
    }

    public void deconstruct() {
        this.client.close();
    }

    private static Optional<Integer> getStatePort(ServiceInfo service) {
        return service.getPorts().stream().filter(port -> port.getTags().contains("state")).map(PortInfo::getPort).findFirst();
    }

    private static long generationFromContainerState(JsonNode state) {
        return state.get(configSubPath).get("generation").asLong();
    }

    private static StateApi createStateApi(Client client, URI uri) {
        WebTarget target = client.target(uri);
        return (StateApi)WebResourceFactory.newResource(StateApi.class, (WebTarget)target);
    }

    private long getServiceGeneration(List<ServiceInfo> services) {
        List serviceUris = services.stream().map(s -> "http://" + s.getHostName() + ":" + ApplicationConvergenceChecker.getStatePort(s).get()).map(URI::create).collect(Collectors.toList());
        long generation = -1L;
        for (URI uri : serviceUris) {
            try {
                long serviceGeneration = this.getServiceGeneration(uri);
                if (generation != -1L && serviceGeneration >= generation) continue;
                generation = serviceGeneration;
            }
            catch (ProcessingException e) {
                return -1L;
            }
        }
        return generation;
    }

    private long getServiceGeneration(URI serviceUri) {
        StateApi state = this.stateApiFactory.createStateApi(this.client, serviceUri);
        return ApplicationConvergenceChecker.generationFromContainerState(state.config());
    }

    private boolean hostInApplication(Application application, String hostPort) {
        for (HostInfo host : application.getModel().getHosts()) {
            if (!hostPort.startsWith(host.getHostname())) continue;
            for (ServiceInfo service : host.getServices()) {
                for (PortInfo port : service.getPorts()) {
                    if (!hostPort.equals(host.getHostname() + ":" + port.getPort())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static class ServiceResponse
    extends JSONResponse {
        final Cursor debug;

        private ServiceResponse(int status, URI uri, String hostname, Long wantedGeneration) {
            super(status);
            this.object.setString("url", uri.toString());
            this.object.setString("host", hostname);
            this.object.setLong("wantedGeneration", wantedGeneration.longValue());
            this.debug = this.object.setObject("debug");
            this.debug.setString("host", hostname);
            this.debug.setLong("wantedGeneration", wantedGeneration.longValue());
        }

        static ServiceResponse createOkResponse(URI uri, String hostname, Long wantedGeneration, Long currentGeneration, boolean converged) {
            ServiceResponse serviceResponse = new ServiceResponse(200, uri, hostname, wantedGeneration);
            serviceResponse.object.setBool("converged", converged);
            serviceResponse.object.setLong("currentGeneration", currentGeneration.longValue());
            serviceResponse.debug.setLong("currentGeneration", currentGeneration.longValue());
            return serviceResponse;
        }

        static ServiceResponse createHostNotFoundInAppResponse(URI uri, String hostname, Long wantedGeneration) {
            ServiceResponse serviceResponse = new ServiceResponse(410, uri, hostname, wantedGeneration);
            serviceResponse.object.setString("problem", "Host:port (service) no longer part of application, refetch list of services.");
            serviceResponse.debug.setString("problem", "Host:port (service) no longer part of application, refetch list of services.");
            return serviceResponse;
        }

        static ServiceResponse createErrorResponse(URI uri, String hostname, Long wantedGeneration, String error) {
            ServiceResponse serviceResponse = new ServiceResponse(500, uri, hostname, wantedGeneration);
            serviceResponse.object.setString("error", error);
            return serviceResponse;
        }

        static ServiceResponse createNotFoundResponse(URI uri, String hostname, Long wantedGeneration, String error) {
            ServiceResponse serviceResponse = new ServiceResponse(404, uri, hostname, wantedGeneration);
            serviceResponse.object.setString("error", error);
            return serviceResponse;
        }
    }

    static class ServiceListResponse
    extends JSONResponse {
        final Cursor debug;

        private ServiceListResponse(int status, List<ServiceInfo> servicesToCheck, URI uri, long wantedGeneration, long currentGeneration) {
            super(status);
            Cursor serviceArray = this.object.setArray("services");
            for (ServiceInfo s : servicesToCheck) {
                Cursor service = serviceArray.addObject();
                String hostName = s.getHostName();
                int statePort = (Integer)ApplicationConvergenceChecker.getStatePort(s).get();
                service.setString("host", hostName);
                service.setLong("port", (long)statePort);
                service.setString("type", s.getServiceType());
                service.setString("url", uri.toString() + "/" + hostName + ":" + statePort);
            }
            this.object.setString("url", uri.toString());
            this.object.setLong("currentGeneration", currentGeneration);
            this.object.setLong("wantedGeneration", wantedGeneration);
            this.object.setBool("converged", currentGeneration >= wantedGeneration);
            this.debug = this.object.setObject("debug");
            this.debug.setLong("wantedGeneration", wantedGeneration);
        }
    }

    public static interface StateApiFactory {
        public StateApi createStateApi(Client var1, URI var2);
    }

    @Path(value="/state/v1/")
    public static interface StateApi {
        @Path(value="config")
        @GET
        public JsonNode config();
    }
}

