/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.config.provision.SystemName;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.TenantsMaintainer;
import com.yahoo.vespa.config.server.maintenance.ZooKeeperDataMaintainer;
import com.yahoo.vespa.curator.Curator;
import java.time.Duration;

public class ConfigServerMaintenance
extends AbstractComponent {
    private final TenantsMaintainer tenantsMaintainer;
    private final ZooKeeperDataMaintainer zooKeeperDataMaintainer;

    public ConfigServerMaintenance(ConfigserverConfig configserverConfig, ApplicationRepository applicationRepository, Curator curator) {
        DefaultTimes defaults = new DefaultTimes(configserverConfig);
        this.tenantsMaintainer = new TenantsMaintainer(applicationRepository, curator, defaults.tenantsMaintainerInterval);
        this.zooKeeperDataMaintainer = new ZooKeeperDataMaintainer(applicationRepository, curator, defaults.zookeeperDataMaintainerInterval);
    }

    public void deconstruct() {
        this.tenantsMaintainer.deconstruct();
        this.zooKeeperDataMaintainer.deconstruct();
    }

    private static class DefaultTimes {
        private final Duration defaultInterval;
        private final Duration tenantsMaintainerInterval;
        private final Duration zookeeperDataMaintainerInterval;

        DefaultTimes(ConfigserverConfig configserverConfig) {
            boolean isCd = configserverConfig.system().equals(SystemName.cd.name());
            this.defaultInterval = Duration.ofMinutes(configserverConfig.maintainerIntervalMinutes());
            this.tenantsMaintainerInterval = isCd ? this.defaultInterval : Duration.ofMinutes(configserverConfig.tenantsMaintainerIntervalMinutes());
            this.zookeeperDataMaintainerInterval = this.defaultInterval;
        }
    }
}

