/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.PrepareResult;
import com.yahoo.vespa.config.server.http.v2.SessionPrepareResponse;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.time.Duration;
import java.time.Instant;

public class SessionPrepareHandler
extends SessionHandler {
    private final TenantRepository tenantRepository;
    private final Duration zookeeperBarrierTimeout;

    @Inject
    public SessionPrepareHandler(LoggingRequestHandler.Context ctx, ApplicationRepository applicationRepository, TenantRepository tenantRepository, ConfigserverConfig configserverConfig) {
        super(ctx, applicationRepository);
        this.tenantRepository = tenantRepository;
        this.zookeeperBarrierTimeout = Duration.ofSeconds(configserverConfig.zookeeper().barrierTimeout());
    }

    @Override
    protected HttpResponse handlePUT(HttpRequest request) {
        Tenant tenant = this.getExistingTenant(request);
        TenantName tenantName = tenant.getName();
        long sessionId = SessionPrepareHandler.getSessionIdV2(request);
        PrepareParams prepareParams = PrepareParams.fromHttpRequest(request, tenantName, this.zookeeperBarrierTimeout);
        PrepareResult result = this.applicationRepository.prepare(tenant, sessionId, prepareParams, Instant.now());
        return new SessionPrepareResponse(result, tenantName, request);
    }

    @Override
    protected HttpResponse handleGET(HttpRequest request) {
        Tenant tenant = this.getExistingTenant(request);
        long sessionId = SessionPrepareHandler.getSessionIdV2(request);
        this.applicationRepository.validateThatRemoteSessionIsNotActive(tenant, sessionId);
        this.applicationRepository.validateThatRemoteSessionIsPrepared(tenant, sessionId);
        return new SessionPrepareResponse(this.createDeployLog(), tenant.getName(), request, sessionId);
    }

    public Duration getTimeout() {
        return this.zookeeperBarrierTimeout.plus(Duration.ofSeconds(10L));
    }

    private Tenant getExistingTenant(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromSessionRequest(request);
        Utils.checkThatTenantExists(this.tenantRepository, tenantName);
        return this.tenantRepository.getTenant(tenantName);
    }
}

