/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.recipes.CuratorLock;
import java.util.concurrent.TimeUnit;

public class ActivateLock {
    private static final String ACTIVATE_LOCK_NAME = "activateLock";
    private final CuratorLock curatorLock;

    public ActivateLock(Curator curator, Path rootPath) {
        this.curatorLock = new CuratorLock(curator, rootPath.append(ACTIVATE_LOCK_NAME).getAbsolute());
    }

    public boolean acquire(TimeoutBudget timeoutBudget, boolean ignoreLockError) {
        try {
            return this.curatorLock.tryLock(timeoutBudget.timeLeft().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (!ignoreLockError) {
                throw new RuntimeException(e);
            }
            return false;
        }
    }

    public void release() {
        if (this.curatorLock.hasLock()) {
            this.curatorLock.unlock();
        }
    }

    public String toString() {
        return "ActivateLock (" + this.curatorLock + "), has lock: " + this.curatorLock.hasLock();
    }
}

