/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.configchange;

import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.ConfigChangeRefeedAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.vespa.config.server.configchange.RefeedActionsFormatter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class RefeedActions {
    private final Map<String, Entry> actions = new TreeMap<String, Entry>();

    private Entry addEntry(String name, boolean allowed, String documentType, ServiceInfo service) {
        String clusterName = service.getProperty("clustername").orElse("");
        String entryId = name + "." + allowed + "." + clusterName + "." + documentType;
        Entry entry = this.actions.get(entryId);
        if (entry == null) {
            entry = new Entry(name, allowed, documentType, clusterName);
            this.actions.put(entryId, entry);
        }
        return entry;
    }

    public RefeedActions() {
    }

    public RefeedActions(List<ConfigChangeAction> actions) {
        for (ConfigChangeAction action : actions) {
            if (!action.getType().equals((Object)ConfigChangeAction.Type.REFEED)) continue;
            ConfigChangeRefeedAction refeedAction = (ConfigChangeRefeedAction)action;
            for (ServiceInfo service : refeedAction.getServices()) {
                this.addEntry(refeedAction.name(), refeedAction.allowed(), refeedAction.getDocumentType(), service).addService(service).addMessage(action.getMessage());
            }
        }
    }

    public List<Entry> getEntries() {
        return new ArrayList<Entry>(this.actions.values());
    }

    public String format() {
        return new RefeedActionsFormatter(this).format();
    }

    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    public static class Entry {
        private final String name;
        private final boolean allowed;
        private final String documentType;
        private final String clusterName;
        private final Set<ServiceInfo> services = new LinkedHashSet<ServiceInfo>();
        private final Set<String> messages = new TreeSet<String>();

        private Entry(String name, boolean allowed, String documentType, String clusterName) {
            this.name = name;
            this.allowed = allowed;
            this.documentType = documentType;
            this.clusterName = clusterName;
        }

        private Entry addService(ServiceInfo service) {
            this.services.add(service);
            return this;
        }

        private Entry addMessage(String message) {
            this.messages.add(message);
            return this;
        }

        public String name() {
            return this.name;
        }

        public boolean allowed() {
            return this.allowed;
        }

        public String getDocumentType() {
            return this.documentType;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public Set<ServiceInfo> getServices() {
            return this.services;
        }

        public Set<String> getMessages() {
            return this.messages;
        }
    }
}

