/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.google.common.base.Splitter;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.server.ServerCache;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerCacheLoader {
    private static final Logger log = Logger.getLogger(ServerCacheLoader.class.getName());
    private final ConfigDefinitionRepo repo;
    private final ConfigCurator configCurator;
    private final Path path;

    public ServerCacheLoader(ConfigCurator configCurator, Path rootPath, ConfigDefinitionRepo repo) {
        this.configCurator = configCurator;
        this.path = rootPath;
        this.repo = repo;
    }

    public ServerCache loadCache() {
        return this.loadConfigDefinitions();
    }

    public ServerCache loadConfigDefinitions() {
        ServerCache cache = new ServerCache();
        try {
            log.log((Level)LogLevel.DEBUG, "Getting config definitions");
            this.loadGlobalConfigDefinitions(cache);
            this.loadConfigDefinitionsFromPath(cache, this.path.append("/userdefconfigs").getAbsolute());
            log.log((Level)LogLevel.DEBUG, "Done getting config definitions");
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load config definitions for " + this.path, e);
        }
        return cache;
    }

    private void loadGlobalConfigDefinitions(ServerCache cache) {
        for (Map.Entry entry : this.repo.getConfigDefinitions().entrySet()) {
            cache.addDef((ConfigDefinitionKey)entry.getKey(), (ConfigDefinition)entry.getValue());
        }
    }

    private void loadConfigDefinitionsFromPath(ServerCache cache, String appPath) {
        if (!this.configCurator.exists(appPath)) {
            return;
        }
        for (String nodeName : this.configCurator.getChildren(appPath)) {
            String payload = this.configCurator.getData(appPath, nodeName);
            ConfigDefinitionKey dKey = ConfigUtils.createConfigDefinitionKeyFromZKString((String)nodeName);
            cache.addDef(dKey, new ConfigDefinition(dKey.getName(), Splitter.on((String)"\n").splitToList((CharSequence)payload).toArray(new String[0])));
        }
    }
}

