/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.log.LogLevel;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.ActivationConflictException;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.ActivateLock;
import com.yahoo.vespa.config.server.tenant.Tenant;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Deployment
implements com.yahoo.config.provision.Deployment {
    private static final Logger log = Logger.getLogger(Deployment.class.getName());
    private final LocalSession session;
    private final ApplicationRepository applicationRepository;
    private final Optional<Provisioner> hostProvisioner;
    private final Tenant tenant;
    private final Duration timeout;
    private final Clock clock;
    private final DeployLogger logger = new SilentDeployLogger();
    private final Version version;
    private boolean prepared = false;
    private boolean validate;
    private boolean ignoreLockFailure = false;
    private boolean ignoreSessionStaleFailure = false;

    private Deployment(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean prepared, boolean validate, Version version) {
        this.session = session;
        this.applicationRepository = applicationRepository;
        this.hostProvisioner = hostProvisioner;
        this.tenant = tenant;
        this.timeout = timeout;
        this.clock = clock;
        this.prepared = prepared;
        this.validate = validate;
        this.version = version;
    }

    public static Deployment unprepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean validate, Version version) {
        return new Deployment(session, applicationRepository, hostProvisioner, tenant, timeout, clock, false, validate, version);
    }

    public static Deployment prepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock) {
        return new Deployment(session, applicationRepository, hostProvisioner, tenant, timeout, clock, true, true, session.getVespaVersion());
    }

    public Deployment setIgnoreLockFailure(boolean ignoreLockFailure) {
        this.ignoreLockFailure = ignoreLockFailure;
        return this;
    }

    public Deployment setIgnoreSessionStaleFailure(boolean ignoreSessionStaleFailure) {
        this.ignoreSessionStaleFailure = ignoreSessionStaleFailure;
        return this;
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, this.timeout);
        this.session.prepare(this.logger, new PrepareParams.Builder().applicationId(this.session.getApplicationId()).timeoutBudget(timeoutBudget).ignoreValidationErrors(!this.validate).vespaVersion(this.version.toString()).build(), Optional.empty(), this.tenant.getPath(), this.clock.instant());
        this.prepared = true;
    }

    public void activate() {
        if (!this.prepared) {
            this.prepare();
        }
        TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, this.timeout);
        long sessionId = this.session.getSessionId();
        this.validateSessionStatus(this.session);
        ActivateLock activateLock = this.tenant.getActivateLock();
        try {
            log.log((Level)LogLevel.DEBUG, "Trying to acquire lock " + activateLock + " for session " + sessionId);
            boolean acquired = activateLock.acquire(timeoutBudget, this.ignoreLockFailure);
            if (!acquired) {
                throw new ActivationConflictException("Did not get activate lock for session " + sessionId + " within " + this.timeout);
            }
            log.log((Level)LogLevel.DEBUG, "Lock acquired " + activateLock + " for session " + sessionId);
            NestedTransaction transaction = new NestedTransaction();
            transaction.add(this.deactivateCurrentActivateNew(this.applicationRepository.getActiveSession(this.session.getApplicationId()), this.session, this.ignoreSessionStaleFailure), new Class[0]);
            if (this.hostProvisioner.isPresent()) {
                this.hostProvisioner.get().activate(transaction, this.session.getApplicationId(), (Collection)this.session.getAllocatedHosts().getHosts());
            }
            transaction.commit();
            this.session.waitUntilActivated(timeoutBudget);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException("Error activating application", e);
        }
        finally {
            log.log((Level)LogLevel.DEBUG, "Trying to release lock " + activateLock + " for session " + sessionId);
            activateLock.release();
            log.log((Level)LogLevel.DEBUG, "Lock released " + activateLock + " for session " + sessionId);
        }
        log.log(LogLevel.INFO, this.session.logPre() + "Session " + sessionId + " activated successfully using " + (this.hostProvisioner.isPresent() ? this.hostProvisioner.get() : "no host provisioner") + ". Config generation " + this.session.getMetaData().getGeneration());
    }

    public void restart(HostFilter filter) {
        this.hostProvisioner.get().restart(this.session.getApplicationId(), filter);
    }

    public LocalSession session() {
        return this.session;
    }

    private long validateSessionStatus(LocalSession localSession) {
        long sessionId = localSession.getSessionId();
        if (Session.Status.NEW.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is not prepared");
        }
        if (Session.Status.ACTIVATE.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is already active");
        }
        return sessionId;
    }

    private Transaction deactivateCurrentActivateNew(LocalSession currentActiveSession, LocalSession session, boolean ignoreStaleSessionFailure) {
        Transaction transaction = session.createActivateTransaction();
        if (this.isValidSession(currentActiveSession)) {
            this.checkIfActiveHasChanged(session, currentActiveSession, ignoreStaleSessionFailure);
            this.checkIfActiveIsNewerThanSessionToBeActivated(session.getSessionId(), currentActiveSession.getSessionId());
            transaction.add(currentActiveSession.createDeactivateTransaction().operations());
        }
        return transaction;
    }

    private boolean isValidSession(LocalSession session) {
        return session != null;
    }

    private void checkIfActiveHasChanged(LocalSession session, LocalSession currentActiveSession, boolean ignoreStaleSessionFailure) {
        long activeSessionAtCreate = session.getActiveSessionAtCreate();
        log.log((Level)LogLevel.DEBUG, currentActiveSession.logPre() + "active session id at create time=" + activeSessionAtCreate);
        if (activeSessionAtCreate == 0L) {
            return;
        }
        long sessionId = session.getSessionId();
        long currentActiveSessionSessionId = currentActiveSession.getSessionId();
        log.log((Level)LogLevel.DEBUG, currentActiveSession.logPre() + "sessionId=" + sessionId + ", current active session=" + currentActiveSessionSessionId);
        if (currentActiveSession.isNewerThan(activeSessionAtCreate) && currentActiveSessionSessionId != sessionId) {
            String errMsg = currentActiveSession.logPre() + "Cannot activate session " + sessionId + " because the currently active session (" + currentActiveSessionSessionId + ") has changed since session " + sessionId + " was created (was " + activeSessionAtCreate + " at creation time)";
            if (ignoreStaleSessionFailure) {
                log.warning(errMsg + " (Continuing because of force.)");
            } else {
                throw new ActivationConflictException(errMsg);
            }
        }
    }

    private void checkIfActiveIsNewerThanSessionToBeActivated(long sessionId, long currentActiveSessionId) {
        if (sessionId < currentActiveSessionId) {
            throw new ActivationConflictException("It is not possible to activate session " + sessionId + ", because it is older than current active session (" + currentActiveSessionId + ")");
        }
    }
}

