/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.vespa.config.server.filedistribution.AddFileInterface;
import com.yahoo.vespa.config.server.filedistribution.ApplicationFileManager;
import com.yahoo.vespa.config.server.filedistribution.CombinedLegacyDistribution;
import com.yahoo.vespa.config.server.filedistribution.CombinedLegacyRegistry;
import com.yahoo.vespa.config.server.filedistribution.FileDBHandler;
import com.yahoo.vespa.config.server.filedistribution.FileDBRegistry;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.filedistribution.FileDistributionManager;
import java.io.File;
import java.util.concurrent.locks.Lock;

public class FileDistributionProvider {
    private final FileRegistry fileRegistry;
    private final FileDistribution fileDistribution;

    public FileDistributionProvider(File applicationDir, String zooKeepersSpec, String applicationId, Lock fileDistributionLock, boolean disableFileDistributor) {
        this.ensureDirExists(FileDistribution.getDefaultFileDBPath());
        FileDistributionManager manager = new FileDistributionManager(FileDistribution.getDefaultFileDBPath(), applicationDir, zooKeepersSpec, applicationId, fileDistributionLock);
        this.fileDistribution = new CombinedLegacyDistribution(new FileDBHandler(manager), disableFileDistributor);
        this.fileRegistry = new CombinedLegacyRegistry(new FileDBRegistry(new ManagerWrapper(manager)), new FileDBRegistry(new ApplicationFileManager(applicationDir, new FileDirectory())));
    }

    FileDistributionProvider(FileRegistry fileRegistry, FileDistribution fileDistribution) {
        this.fileRegistry = fileRegistry;
        this.fileDistribution = fileDistribution;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public FileDistribution getFileDistribution() {
        return this.fileDistribution;
    }

    private void ensureDirExists(File dir) {
        boolean success;
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new RuntimeException("Could not create directory " + dir.getPath());
        }
    }

    private static class ManagerWrapper
    implements AddFileInterface {
        private final FileDistributionManager manager;

        ManagerWrapper(FileDistributionManager manager) {
            this.manager = manager;
        }

        @Override
        public FileReference addFile(String relativePath) {
            return new FileReference(this.manager.addFile(relativePath));
        }

        @Override
        public FileReference addFile(String relativePath, FileReference reference) {
            throw new IllegalStateException("addFile with external reference is not possible with legacy filedistribution.");
        }
    }
}

