/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.filedistribution.FileDBHandler;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;

public class CombinedLegacyDistribution
implements FileDistribution {
    private static final Logger log = Logger.getLogger(CombinedLegacyDistribution.class.getName());
    private final Supervisor supervisor = new Supervisor(new Transport());
    private final FileDistribution legacy;

    CombinedLegacyDistribution(FileDBHandler legacy) {
        this.legacy = legacy;
    }

    public void sendDeployedFiles(String hostName, Set<FileReference> fileReferences) {
        this.legacy.sendDeployedFiles(hostName, fileReferences);
    }

    public void startDownload(String hostName, Set<FileReference> fileReferences) {
    }

    public void reloadDeployFileDistributor() {
        this.legacy.reloadDeployFileDistributor();
    }

    public void removeDeploymentsThatHaveDifferentApplicationId(Collection<String> targetHostnames) {
        this.legacy.removeDeploymentsThatHaveDifferentApplicationId(targetHostnames);
    }

    private void startDownloadingFileReferences(String hostName, Set<FileReference> fileReferences) {
        Target target = this.supervisor.connect(new Spec(hostName, 19090));
        double timeout = 0.1;
        Request request = new Request("filedistribution.setFileReferencesToDownload");
        request.parameters().add((Value)new StringArray((String[])fileReferences.stream().map(FileReference::value).toArray(String[]::new)));
        log.log(LogLevel.INFO, "Executing " + request.methodName() + " against " + target.toString());
        target.invokeSync(request, timeout);
        if (request.isError()) {
            log.log(LogLevel.INFO, request.methodName() + " failed: " + request.errorCode() + " (" + request.errorMessage() + ")");
        }
    }
}

