/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.host.HostRegistries;
import com.yahoo.vespa.config.server.host.HostRegistry;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.JSONResponse;
import com.yahoo.vespa.config.server.http.v2.HttpConfigRequests;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class HostHandler
extends HttpHandler {
    final HostRegistries hostRegistries;
    private final Zone zone;

    public HostHandler(Executor executor, AccessLog accessLog, GlobalComponentRegistry globalComponentRegistry) {
        super(executor, accessLog);
        this.hostRegistries = globalComponentRegistry.getHostRegistries();
        this.zone = globalComponentRegistry.getZone();
    }

    @Override
    public HttpResponse handleGET(HttpRequest request) {
        String hostname = HostHandler.getBindingMatch(request).group(2);
        this.log.log((Level)LogLevel.DEBUG, "hostname=" + hostname);
        HostRegistry<TenantName> tenantHostRegistry = this.hostRegistries.getTenantHostRegistry();
        this.log.log((Level)LogLevel.DEBUG, "hosts in tenant host registry '" + tenantHostRegistry + "' " + tenantHostRegistry.getAllHosts());
        TenantName tenant = tenantHostRegistry.getKeyForHost(hostname);
        if (tenant == null) {
            return this.createError(hostname);
        }
        this.log.log((Level)LogLevel.DEBUG, "tenant=" + tenant);
        HostRegistry<ApplicationId> applicationIdHostRegistry = this.hostRegistries.getApplicationHostRegistry(tenant);
        if (applicationIdHostRegistry == null) {
            return this.createError(hostname);
        }
        ApplicationId applicationId = applicationIdHostRegistry.getKeyForHost(hostname);
        this.log.log((Level)LogLevel.DEBUG, "applicationId=" + applicationId);
        if (applicationId == null) {
            return this.createError(hostname);
        }
        this.log.log((Level)LogLevel.DEBUG, "hosts in application host registry '" + applicationIdHostRegistry + "' " + applicationIdHostRegistry.getAllHosts());
        return new HostResponse(200, applicationId, this.zone);
    }

    private HttpErrorResponse createError(String hostname) {
        return HttpErrorResponse.notFoundError("Could not find any application using host '" + hostname + "'");
    }

    private static BindingMatch<?> getBindingMatch(HttpRequest request) {
        return HttpConfigRequests.getBindingMatch(request, "http://*/application/v2/host/*");
    }

    private static class HostResponse
    extends JSONResponse {
        public HostResponse(int status, ApplicationId applicationId, Zone zone) {
            super(status);
            this.object.setString("tenant", applicationId.tenant().value());
            this.object.setString("application", applicationId.application().value());
            this.object.setString("environment", zone.environment().value());
            this.object.setString("region", zone.region().value());
            this.object.setString("instance", applicationId.instance().value());
        }
    }
}

