/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.io.IOUtils;
import com.yahoo.text.Utf8;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;

public class FileDirectory {
    private static final Logger log = Logger.getLogger(FileDirectory.class.getName());
    private final File root;

    public FileDirectory() {
        this(FileDistribution.getDefaultFileDBPath());
    }

    public FileDirectory(File rootDir) {
        this.root = rootDir;
        try {
            this.ensureRootExist();
        }
        catch (IllegalArgumentException e) {
            log.warning("Failed creating directory in constructor, will retry on demand : " + e.toString());
        }
    }

    private void ensureRootExist() {
        if (!this.root.exists()) {
            if (!this.root.mkdir()) {
                throw new IllegalArgumentException("Failed creating root dir '" + this.root.getAbsolutePath() + "'.");
            }
        } else if (!this.root.isDirectory()) {
            throw new IllegalArgumentException("'" + this.root.getAbsolutePath() + "' is not a directory");
        }
    }

    String getPath(FileReference ref) {
        return this.root.getAbsolutePath() + "/" + ref.value();
    }

    File getFile(FileReference reference) {
        this.ensureRootExist();
        File dir = new File(this.getPath(reference));
        if (!dir.exists()) {
            throw new IllegalArgumentException("File reference '" + reference.toString() + "' with absolute path '" + dir.getAbsolutePath() + "' does not exist.");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File reference '" + reference.toString() + "' with absolute path '" + dir.getAbsolutePath() + "' is not a directory.");
        }
        File[] files = dir.listFiles(new Filter());
        if (files.length != 1) {
            StringBuilder msg = new StringBuilder();
            for (File f : files) {
                msg.append(f.getName()).append("\n");
            }
            throw new IllegalArgumentException("File reference '" + reference.toString() + "' with absolute path '" + dir.getAbsolutePath() + " does not contain exactly one file, but [" + msg.toString() + "]");
        }
        return files[0];
    }

    private Long computeReference(File file) throws IOException {
        byte[] wholeFile = IOUtils.readFileBytes((File)file);
        XXHash64 hasher = XXHashFactory.fastestInstance().hash64();
        return hasher.hash(ByteBuffer.wrap(wholeFile), hasher.hash(ByteBuffer.wrap(Utf8.toBytes((String)file.getName())), 0L));
    }

    public FileReference addFile(File source) {
        try {
            Long hash = this.computeReference(source);
            FileReference reference = new FileReference(Long.toHexString(hash));
            return this.addFile(source, reference);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public FileReference addFile(File source, FileReference reference) {
        this.ensureRootExist();
        try {
            File destinationDir = new File(this.root, reference.value());
            if (!destinationDir.exists()) {
                destinationDir.mkdir();
                Path tempDestinationDir = Files.createTempDirectory(this.root.toPath(), "writing", new FileAttribute[0]);
                File destination = new File(tempDestinationDir.toFile(), source.getName());
                if (source.isDirectory()) {
                    IOUtils.copyDirectory((File)source, (File)destination);
                } else {
                    IOUtils.copy((File)source, (File)destination);
                }
                if (!destinationDir.exists()) {
                    if (!tempDestinationDir.toFile().renameTo(destinationDir)) {
                        log.warning("Failed moving '" + tempDestinationDir.toFile().getAbsolutePath() + "' to '" + destination.getAbsolutePath() + "'.");
                    }
                } else {
                    IOUtils.copyDirectory((File)tempDestinationDir.toFile(), (File)destinationDir, (int)1);
                }
                IOUtils.recursiveDeleteDir((File)tempDestinationDir.toFile());
            }
            return reference;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class Filter
    implements FilenameFilter {
        private Filter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !".".equals(name) && !"..".equals(name);
        }
    }
}

