/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.LocalSessionLoader;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepo;
import java.io.File;
import java.io.FilenameFilter;
import java.time.Clock;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class LocalSessionRepo
extends SessionRepo<LocalSession> {
    private static final Logger log = Logger.getLogger(LocalSessionRepo.class.getName());
    private static final FilenameFilter sessionApplicationsFilter = (dir, name) -> name.matches("\\d+");
    private final long sessionLifetime;
    private final Clock clock;

    public LocalSessionRepo(TenantFileSystemDirs tenantFileSystemDirs, LocalSessionLoader loader, Clock clock, long sessionLifeTime) {
        this(clock, sessionLifeTime);
        this.loadSessions(tenantFileSystemDirs.sessionsPath(), loader);
    }

    public LocalSessionRepo(Clock clock) {
        this(clock, TimeUnit.DAYS.toMillis(1L));
    }

    private LocalSessionRepo(Clock clock, long sessionLifetime) {
        this.sessionLifetime = sessionLifetime;
        this.clock = clock;
    }

    private void loadSessions(File applicationsDir, LocalSessionLoader loader) {
        File[] applications = applicationsDir.listFiles(sessionApplicationsFilter);
        if (applications == null) {
            return;
        }
        for (File application : applications) {
            try {
                this.addSession(loader.loadSession(Long.parseLong(application.getName())));
            }
            catch (IllegalArgumentException e) {
                log.log(LogLevel.WARNING, "Could not load application '" + application.getAbsolutePath() + "':" + e.getMessage() + ", skipping it.");
            }
        }
    }

    @Override
    public synchronized void addSession(LocalSession session) {
        this.purgeOldSessions();
        super.addSession(session);
    }

    private void purgeOldSessions() {
        ArrayList sessions = new ArrayList(this.listSessions());
        for (LocalSession candidate : sessions) {
            if (!this.hasExpired(candidate) || this.isActiveSession(candidate)) continue;
            this.deleteSession(candidate);
        }
    }

    private boolean hasExpired(LocalSession candidate) {
        return candidate.getCreateTime() + this.sessionLifetime <= TimeUnit.MILLISECONDS.toSeconds(this.clock.millis());
    }

    private boolean isActiveSession(LocalSession candidate) {
        return candidate.getStatus() == Session.Status.ACTIVATE;
    }

    private void deleteSession(LocalSession candidate) {
        this.removeSessionOrThrow(candidate.getSessionId());
        candidate.delete();
    }

    public void deleteAllSessions() {
        ArrayList sessions = new ArrayList(this.listSessions());
        for (LocalSession session : sessions) {
            this.deleteSession(session);
        }
    }
}

